<?php

namespace App\Http\Controllers;

use App\Models\Branch;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class BranchController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $list = Branch::paginate('100');
        return view('branch.index',[
            'page_title' => 'Branch List',
            'list' => $list,
            'url' => route('branch.create'),
            'add_button' => 'true',
            'class' => 'btn btn-primary',
            'value' => 'Add New Branch'
             ]);
    }


    public function create()
    {
        return view('branch.create',[
            'page_title'=> 'Add New Branch'
        ]);
    }


    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required',
            'short_name' => 'nullable',
            'contact_no' => 'nullable',
            'address' => 'nullable',
            'remarks' => 'nullable',
        ]);

        $branch = new Branch();
        $branch->fill($request->all());
        $branch->creator_user_id = Auth::id();
        $branch->save();
        $request->session()->flash('success_message', 'Branch Added successfull');
        return redirect()->route('branch.index');
    }




    public function edit(Branch $branch)
    {
        return view('branch.update',[
            'list' => $branch,
            'page_title' => 'Update Branch Information'
        ]);
    }


    public function update(Request $request, Branch $branch)
    {
        $this->validate($request, [
            'name' => 'required',
            'contact_no' => 'required',
            'address' => 'required',
        ]);

        $branch->fill($request->all());
        $branch->update();

        $request->session()->flash('success_message', 'Branch Update successfull');
        return redirect()->route('branch.index');
    }


}
