<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Employee extends Model
{
    use HasFactory;
    protected $guarded = ['id'];

    static function onlinePaymentEmployee($name)
    {
        $employee = Employee::where('name',$name)->first();

        if($employee){
            return $employee;
        }else{
            $employee = Employee::create([
                'name' => $name,
                'designation' => $name.' Payment Gateway'
            ]);

            return $employee;
        }
    }

    public function admin(){
        return $this->belongsTo(User::class, 'admin_user_id', 'id');
    }

    public function assignedTickets(){
        $todayEnd = date('Y-m-d 23:59:59');
        $startOfLastThirtyDays = date('Y-m-d 00:00:00', strtotime('-30 days'));
        return $this->hasMany(Token::class, 'assignToken', 'id')->where('close_time','!=',null)->whereBetween('created_at', [$startOfLastThirtyDays, $todayEnd]);
    }
}
