import React from "react";
import { useSelector } from "react-redux";

import { ShowClientOnMap } from "./ShowClientOnMap";

const ShowClientsOnMap = ({ cluster }) => {
    const { boxClients } = useSelector(
        ({ boxClientReducer }) => boxClientReducer
    );
    if (boxClients.length === 0 || !(cluster.id in boxClients)) return null;

    return (
        <>
            {boxClients[cluster.id].map((client) => (
                <ShowClientOnMap
                    key={client.client.id}
                    clientInfo={client}
                    cluster={cluster}
                />
            ))}
        </>
    );
};

export default ShowClientsOnMap;
