@extends('layout.app')
@section('content')
    <div class="card">
        <div class="card-body">
            <h4 class="text-center">Please Enter New Bank Information</h4>
            <hr>
            <form action="{{ route('banking.update', $banking->id) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="row">
                    <div class="col-md-6 m-auto">
                        <div>
                            <label for="">Account's Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="account_name"
                                value="{{ $banking->account_name }}">
                            @error('account_name')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="mt-3">
                            <label for="">Account No <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="account_no" value="{{ $banking->account_no }}">
                            @error('account_no')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="mt-3">
                            <label for="">Bank Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="bank_name" value="{{ $banking->bank_name }}">
                            @error('bank_name')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="mt-3">
                            <label for="">Branch Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="branch_name"
                                value="{{ $banking->branch_name }}">
                            @error('branch_name')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="mt-3">
                            <label for="">Status <span class="text-danger">*</span></label>
                            <select name="status" id="" class="form-control">
                                <option value="">Select Status</option>
                                <option {{ $banking->status == 1 ? 'selected' : '' }} selected value="1">Active
                                </option>
                                <option {{ $banking->status == 0 ? 'selected' : '' }} value="0">Inactive</option>
                            </select>
                            @error('status')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="mt-3">
                            <label for="">Opening balance <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" name="opening_balance"
                                value="{{ $banking->opening_balance }}">
                            @error('opening_balance')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <button class="btn btn-success mt-4" style="float: right">Update</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('js')
@endpush
