@extends('layout.app')
@section('content')

    <div class="card">
        <div class="card-body">

          <div class="card-header bg-light">
            <div class="card-tools">

                <button type="button" class="btn btn-primary" data-toggle="modal"
                    data-target="#modal-fund-transfer">
                    New Commission Transfer
                </button>
            </div>
        </div>


            <div class="table-responsive">


                <table class="table" style="width:100%">
                    <thead style="width:100%">
                        <tr>
                            <th class="bg-dark">Name</th>
                            <th class="bg-dark">Received Commission</th>
                            <th class="bg-dark">Paid Commission</th>
                            <th class="bg-dark">Balance</th>
                            <th class="bg-dark">Action</th>
                        </tr>
                    </thead>

                    <tbody>
                      @php

                      @endphp
                      @foreach($managers as $m)

                      <tr>
                        <td>{{$m->name}}</td>
                        <td>
                          @foreach($accounts as $ac) @if($ac->reseller_id == $m->id)  {{ $ac->ramount }} @endif @endforeach
                        </td>
                        <td>@foreach($accounts as $ac) @if($ac->reseller_id == $m->id) {{ $ac->pamount??0 }} @endif @endforeach</td>
                        <td>@foreach($accounts as $ac) @if($ac->reseller_id == $m->id) {{ $ac->ramount - $ac->pamount }} @endif @endforeach</td>
                        <td>


                          <a href="{{ route('view-reseller-commission', $m->id) }}" class="btn btn-primary"><i class="fa fa-eye"></i></a>
                        </td>

                      </tr>

                      @endforeach



                    </tbody>
                </table>




            </div>

              <div class="modal fade" id="modal-fund-transfer">
                <div class="modal-dialog">
                    <form action="{{ route('commission-transfer') }}" method="POST">
                        @csrf
                        @method('post')
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="text-center">Commission Transfer</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <div class="text-center" id="modalAlert"></div>

                                <div class="row">


                                    <div class="col-md-4">Commission Send To</div>
                                    <div class="col-md-8 mb-2">
                                        <select class="form-control select2" name="received_by" id="">
                                            <option value="">Select Reseller</option>
                                            @foreach ($managers as $s)
                                                @php
                                                    $totalAmount = 0;
                                                    foreach ($accounts as $ac) {
                                                        if ($ac->reseller_id == $s->id) {
                                                            $totalAmount += $ac->ramount - $ac->pamount;
                                                        }
                                                    }
                                                @endphp
                                                @if ($totalAmount > 0)
                                                    <option value="{{ $s->id }}">
                                                        {{ $s->name }} -- BDT {{ $totalAmount }}
                                                    </option>
                                                @endif
                                                {{-- <option value="{{ $s->id }}">{{ $s->name }} -- BDT
                                                    @foreach($accounts as $ac) @if($ac->reseller_id == $s->id) {{ $ac->ramount - $ac->pamount }} @endif @endforeach
                                                </option> --}}
                                            @endforeach
                                        </select>
                                        <input type="hidden" name="transfer_type" value="fund_transfer">
                                    </div>

                                    <div class="col-md-4">Transfer Type</div>
                                    <div class="col-md-8 mb-2">
                                        <select name="txn_type" class="form-control select2">
                                            <option value="">Select One</option>
                                            <option value="Cash">Cash</option>
                                            <option value="ManagerRecharge">Account Recharge</option>
                                        </select>
                                    </div>

                                    <div class="col-md-4">Transfer Amount</div>
                                    <div class="col-md-8 mb-2">
                                        <input type="number" name="amount" class="form-control">
                                    </div>

                                    <div class="col-md-4">Note</div>
                                    <div class="col-md-8 mb-2">
                                        <textarea name="note" id="note" class="form-control"></textarea>
                                    </div>


                                </div>


                            </div>
                            <div class="modal-footer justify-content-between">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button class="btn btn-primary" type="submit" id="modalSave">Transfer</button>
                            </div>

                        </div>
                        <!-- /.modal-content -->
                    </form>
                </div>
                <!-- /.modal-dialog -->
            </div>

        </div>
    </div>




@endsection


