@extends('layout.app')

@section('content')


   <div class="card">
        <div class="card-body">
            <div class="table-responsive">
            <table id="dataTable" class="table table-bordered ">
                <thead>
                    <tr>
                        <th>
                            ID
                        </th>
                        <th>
                            Requisition No.
                        </th>
                        <th>
                            Branch
                        </th>
                        <th>
                            Status
                        </th>
                        <th>
                            Create Date
                        </th>
                        <th>
                            Location
                        </th>
                        <th>
                            Purposes
                        </th>
                        <th>
                            Recommendations
                        </th>
                        <th>
                            Remarks
                        </th>
                        <th>Employee Name</th>
                        <th>Submited By </th>
                        <th>
                            Submitted File
                        </th>

                    </tr>
                </thead>

                <tbody>


                    @foreach ($list as $r)
                            <tr>
                            <td class="text-center">
                                {{ $r->id }}
                            </td>

                            <td class="text-center">
                                {{ $r->requisition_number}}
                            </td>

                            <td class="text-center">
                                {{ $r->branchName}}
                            </td>

                            <td class="text-center">
                                {{ $r->status }}
                            </td>

                            <td class="text-center">
                               {{ date('d-M-Y H:i:s A', strtotime($r->created_at)) }}
                            </td>

                            <td class="text-center">
                                {{ $r->location }}
                            </td>

                            <td class="text-center">
                                {{ $r->purposes }}
                            </td>

                            <td class="text-center">
                                {{ $r->recommendation }}
                            </td>

                            <td class="text-center">
                                {{ $r->remark}}
                            </td>

                            <td class="text-center">
                                {{ $r->name}}
                            </td>

                            <td class="text-center">
                                {{ $r->author}}
                            </td>

                            <td class="text-center ">

                             <?php
                               $file = true;
                               $extension = '';
                               $imageFileExtens = ['jpeg','png','jpg'];
                               if($r->auth_file){
                                $pathExtension =asset('storage/requsition/'.$r->auth_file);
                                $fileInfo = pathinfo($pathExtension);
                                $extension = $fileInfo['extension'];
                               }
                               elseif($r->auth_file === NULL) {
                                $file = false;
                               }
                             ?>

                             @if($extension ==='pdf')
                              <x-modal.pdfviewer :pdf="$r->auth_file" :id="$r->id" />
                              <button type="button"
                              class="btn btn-secondary m-2"
                              data-toggle="modal"
                              data-target="#pdfModal{{$r->id}}">
                                View PDF
                              </button>

                            @elseif(in_array($extension,$imageFileExtens))
                             <x-modal.imageviewer :image="$r->auth_file" :id="$r->id" />
                                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#imageModal{{$r->id}}">View Image
                               </button>
                            @elseif($file !== true)
                            <h6 class="lead">File Not Provided</h6>

                            @endif
                            </td>



                        </tr>


                    @endforeach

                </tbody>
                <!-- More items... -->
                {{-- {{ $list->links() }} --}}
            </table>
            </div>


        </div>
    </div>

@endsection
