@extends('layout.app')
@section('content')
    {{-- @dd($model) --}}
    <form action="{{ route('reseller-area.update', $model) }}" method="POST">
        @method('PUT')
        @csrf
        <div class="card">
            <div class="card-body">

                <input type="hidden" name="id" value="{{ $model->id }}">
                <div class="row">
                <div class="form-group col-md-4">
                    <label for="reseller_id" class="block text-sm font-medium text-gray-700">
                        Manager*
                    </label>
                    <select class="select2 form-control" name="reseller_id" id="reseller">
                        <option value="">Select One</option>
                        @forelse ($reseller as $item)
                            <option value="{{ $item->id }}" {{ $item->id == $model->reseller_id ? 'selected' : '' }}>
                                {{ $item->name }}</option>
                        @empty
                        @endforelse
                    </select>
                    @error('reseller_id')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <div class="form-group col-md-4 @if (globalPermission('hidePopOnCreateArea')) d-none @endif "">
                    <label> Select POP </label>
                    <select name="pop_id" id="pop" class="select2 form-control ">
                        <option value="{{ $model->pop_id }}">
                            {{ $model->pop->popname ?? '' }}</option>
                    </select>
                </div>

                <div class="form-group col-md-4">
                    <label for="area" class="block text-sm font-medium text-gray-700">
                        Area*
                    </label>
                    <input type="text" name="area" id="area" class="form-control" placeholder="Area"
                        value="{{ $model->area }}" autocomplete="off">
                    @error('area')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
            </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-primary float-right">
                        Update
                    </button>
                </div>

            </div>
        </div>


    </form>
@endsection

@section('ajax')
    <script type="text/javascript">
        window.setTimeout(function() {
            window.location.reload();
        }, 100000);

        $(function() {

            $('#reseller').on('change', function(e) {
                e.preventDefault();
                $('body').append('<div class="hidden" id="processing">processing.....</div>');

                $.ajax({
                    type: 'get',
                    url: '{{ route('getResellerPopList') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#pop').html(result);
                        $('#processing').remove();
                    }
                });
            });

        });
    </script>
@endsection
