@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">
            <form action="" id="search">

                <div class="row">
                    <div class="col-md-2">
                        <label class="" for="from_date">
                            Search By
                        </label>
                    </div>
                    <div class="col-md-4">
                        <select name="type" class="form-control" required>

                            <option value="id">ID</option>
                            <option value="userid" selected>User Name</option>
                            <option value="contact_no">Contact No</option>

                        </select>
                    </div>
                    <div class="col-md-4">
                        <input class="form-control" name="value" type="text" placeholder="" required>

                    </div>
                </div>

                <div class="form-group float-right mt-2">
                    <button @click="search" class="btn btn-primary" type="submit" id="searchBtn"><i
                            class="fa fa-search"></i> Search</button>
                    <button class="btn btn-info" type="reset" id="reset">Reset</button>

                </div>

            </form>

            <div id="result">
                {{-- list will show in this box --}}
            </div>


            <div class="py-10" id="show_hide" style="display: none">


                <ul class="nav nav-tabs tabs-nav btn-group bg-gray mt-2">
                    <li>
                        <a class="m-1 btn btn-success nav-item nav-link active" href="#summary">Summary</a>
                    </li>
                    <li>
                        <a class="m-1 btn btn-success nav-item nav-link" href="#contact">Contact Details</a>
                    </li>
                    <li class="dropdown">
                        <button class="m-1 btn btn-success dropdown-toggle" type="button" id="dropdownMenuButton"
                            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Techical Information
                        </button>
                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            <a class="nav-item nav-link" href="#technical-details">Technical Details</a>

                            <a class="nav-item nav-link" href="#log-details">Log History</a>

                            <a class="nav-item nav-link" href="#login-attempts">Login Attempts</a>
                        </div>
                    </li>
                    <li class="dropdown">
                        <button class="m-1 btn btn-success dropdown-toggle" type="button" id="connectionPanel"
                            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Connection Panel
                        </button>
                        <div aria-labelledby='connectionPanel' class="dropdown-menu">

                            <a class="m-1 btn btn-success nav-item nav-link" href="#connection-history">Connection
                                History</a>
                            @hasrole('Admin|Support Executive|Support Manager|Accounts Manager')
                                <a class="m-1 btn btn-success nav-item nav-link" href="#client_edit_log">Client Edit Log</a>
                            @endhasrole
                            <button type="button" class="btn btn-primary float-right" data-toggle="modal"
                                data-target="#manage-connection">
                                Manage Connection
                            </button>
                            {{-- <a class="m-1 btn btn-info nav-item nav-link" href="#connection-management">Manage Connection</a> --}}

                        </div>
                    </li>

                    <li>
                        <a class="m-1 btn btn-success nav-item nav-link" href="#token">Pending Token</a>
                    </li>

                    <li>
                        <a class="m-1 btn btn-success nav-item nav-link" href="#previous_token">Previous Token</a>
                    </li>

                </ul>
                <div class="tabs-content" id="myTabContent">

                    <div id="summary">


                        <table class="table">
                            <tr>
                                <td>
                                    <label for="name" class="text-right d-block">
                                        Status
                                    </label>

                                </td>
                                <td>
                                    <p id="clients_status"></p>
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <label for="name" class="text-right d-block">
                                        Total Due
                                    </label>
                                </td>
                                <td>
                                    <input readonly type="text" name="name" id="totaldue" value=""
                                        class="form-control">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <label for="customer_since" class="text-right d-block">
                                        Customer Since
                                    </label>
                                </td>
                                <td>
                                    <input readonly type="text" name="customer_since" id="customer_since" value=""
                                        class="form-control" readonly>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <label for="name" class="text-right d-block">
                                        Last logout
                                    </label>
                                </td>
                                <td>
                                    <input readonly type="text" name="name" id="last_logout" value=""
                                        class="form-control" readonly>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <label for="name" class="text-right d-block">
                                        Created By
                                    </label>
                                </td>
                                <td>
                                    <input readonly type="text" name="created_by" id="created_by" value=""
                                        class="form-control">
                                </td>
                            </tr>

                            <tr>
                                <td>
                                    <label for="userstatus" class="text-right d-block">User Status</label>
                                </td>
                                <td>
                                    <p id="onlineUser"></p>
                                    <p id="edit_user"></p>
                                    <p id="disconnect"></p>
                                    <p id="resync"></p>
                                    @can('delete-single-id-from-online')
                                        <p id="deleteFrom_radacctTable"></p>
                                    @endcan

                                </td>

                            </tr>



                        </table>


                    </div>
                    <div id="contact">


                        <table class="table">
                            <tr>
                                <td>
                                    <label for="name" class="text-right d-block">
                                        Customer Name
                                    </label>
                                </td>
                                <td>
                                    <input readonly type="text" name="name" id="c_name" value=""
                                        class="form-control">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <label for="name" class="text-right d-block">
                                        Contact Number
                                    </label>
                                </td>
                                <td>
                                    <input readonly type="text" name="name" id="c_contact_no" value=""
                                        class="form-control">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <label for="name" class="text-right d-block">
                                        Email
                                    </label>
                                </td>
                                <td>
                                    <input readonly type="text" name="name" id="c_email" value=""
                                        class="form-control">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <label for="name" class="text-right d-block">
                                        Reseller
                                    </label>
                                </td>

                                <td>
                                    <input readonly type="text" name="pop_id" id="pop_name" value=""
                                        class="form-control">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <label for="area" class="text-right d-block">
                                        Address
                                    </label>
                                </td>
                                <td>
                                    <input readonly type="text" name="area" id="area" value=""
                                        class="form-control">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <label for="name" class="text-right d-block">
                                        Father
                                    </label>
                                </td>
                                <td>
                                    <input readonly type="text" name="father_name" id="father_name" value=""
                                        class="form-control">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <label for="name" class="text-right d-block">
                                        Mother
                                    </label>
                                </td>
                                <td>
                                    <input readonly type="text" name="name" id="mother_name" value=""
                                        class="form-control">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <label for="name" class="text-right d-block">
                                        NID
                                    </label>
                                </td>
                                <td>
                                    <input readonly type="text" name="name" id="national_id" value=""
                                        class="form-control">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <label for="password" class="text-right d-block">
                                        Passport
                                    </label>
                                </td>
                                <td>
                                    <input readonly type="text" name="name" id="passport_no" value=""
                                        class="form-control">
                                </td>
                            </tr>
                        </table>

                    </div>
                    <div id="technical-details">
                        <table class="table">
                            <tr>
                                <td>
                                    <label for="userid" class="text-right">
                                        User Id
                                    </label>
                                </td>
                                <td>
                                    <input readonly type="text" name="userid" id="userid" value=""
                                        class="form-control">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <label for="password" class="text-right">
                                        Password
                                    </label>
                                </td>
                                <td>
                                    <input readonly type="text" name="password" id="password" value=""
                                        class="form-control">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <label for="name" class="text-right">
                                        IP Address
                                    </label>
                                </td>
                                <td>
                                    <input readonly type="text" name="ip_address" id="ip_address" value=""
                                        class="form-control">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <label for="mac" class="text-right">
                                        MAC Address
                                    </label>
                                </td>
                                <td>
                                    <input readonly type="text" name="mac" id="mac" value=""
                                        class="form-control">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <label for="name" class="text-right">
                                        POP Name
                                    </label>
                                </td>
                                <td>
                                    <input readonly type="text" name="pop_id" id="pop_id" value=""
                                        class="form-control">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <label for="name" class="text-right">
                                        Package
                                    </label>
                                </td>
                                <td>
                                    <input readonly type="text" name="package_name" id="package_name" value=""
                                        class="form-control">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <label for="name" class="text-right">
                                        Expired Date
                                    </label>
                                </td>
                                <td>
                                    <input readonly type="text" name="expire_date" id="expire_date" value=""
                                        class="form-control">
                                </td>
                            </tr>

                        </table>



                    </div>

                    <div id="log-details">

                        <table class="table table-responsive table-bordered">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th scope="col">
                                        Action Date
                                    </th>
                                    <th scope="col">
                                        Activity
                                    </th>
                                    <th scope="col">
                                        Remarks
                                    </th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200" id="log_activities">

                            </tbody>
                        </table>
                    </div>

                    <div id="login-attempts">
                        <table class="table table-responsive table-bordered">
                            <thead class="bg-gray-50">
                                @if (checkAPI())
                                    <tr>
                                        <th scope="col">
                                            Time
                                        </th>
                                        <th scope="col">
                                            Message
                                        </th>
                                    @else
                                    <tr>
                                        <th scope="col">
                                            DateTime
                                        </th>
                                        <th scope="col">
                                            User Name
                                        </th>

                                        <th scope="col">
                                            Password
                                        </th>
                                        <th scope="col">
                                            MAC Address
                                        </th>
                                        <th scope="col">
                                            Remarks
                                        </th>
                                        <th scope="col">
                                            Mikrotik
                                        </th>
                                    </tr>
                                @endif

                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200" id="login_attempts">

                            </tbody>
                        </table>

                    </div>

                    <div id="connection-history">


                        <table class="table table-responsive table-bordered">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th scope="col">
                                        Action date
                                    </th>

                                    <th scope="col">
                                        Action Name
                                    </th>
                                    <th scope="col">
                                        Remarks
                                    </th>
                                    <th scope="col">
                                        Action Taken By
                                    </th>

                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200" id="connection_history">

                            </tbody>
                        </table>

                    </div>

                    <div id="client_edit_log">

                        {{-- <a class="m-1 btn btn-success " href="{{route('all-client-edit-log',$id)}}">View All Client Edit Log</a> --}}

                        <table class="table table-responsive table-bordered">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th scope="col">
                                        Edit By
                                    </th>

                                    <th scope="col">
                                        Old Data
                                    </th>
                                    <th scope="col">
                                        New Data
                                    </th>


                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200" id="edit_log_history">

                            </tbody>
                        </table>

                    </div>

                    <div id="token">
                        <table class="table">
                            <thead>
                                <tr>
                                    <td>Date</td>
                                    <td>Token</td>
                                    <td>Category</td>
                                    <td>Code</td>
                                    <td>Reporter</td>
                                    <td>Reporter Contact</td>
                                    <td>Description</td>
                                    <td>Status</td>
                                </tr>
                            </thead>

                            <tbody class="bg-white divide-y divide-gray-200" id="token_output">

                            </tbody>
                        </table>
                    </div>

                    <div id="previous_token">
                        <table class="table">
                            <thead>
                                <tr>
                                    <td>Date</td>
                                    <td>Token</td>
                                    <td>Category</td>
                                    <td>Code</td>
                                    <td>Reporter</td>
                                    <td>Reporter Contact</td>
                                    <td>Description</td>
                                    <td>Status</td>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200" id="previous_token_output"></tbody>
                        </table>
                    </div>

                </div>
            </div>


        </div>
    </div>

    <div class="modal fade" id="manage-connection">
        <div class="modal-dialog">
            <form action="{{ route('enableDisable') }}" method="POST">
                @csrf
                @method('post')
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="text-center">Connection Management</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="text-center" id="modalAlert"></div>

                        <div class="row">

                            <div class="col-md-4">Customer ID</div>
                            <div class="col-md-8 mb-2">
                                <p id="customerIDShow"></p>
                                <input type="hidden" name="id" id="customerID" value=""
                                    class="form-control disable">
                            </div>

                            <div class="col-md-4">Activity Name</div>
                            <div class="col-md-8 mb-2">
                                <select name="activity_name" id="activity_name" class="form-control">
                                    <option value="">Select Type</option>
                                    <option value="active">Enable</option>
                                    <option value="disable">Disable</option>
                                    <option value="deactive">Deactive</option>
                                </select>
                            </div>

                            <div class="col-md-4">Remark</div>
                            <div class="col-md-8 mb-2">

                                <textarea name="details" id="details" class="form-control"></textarea>
                            </div>


                        </div>


                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button class="btn btn-primary" type="submit" id="modalSave">Change</button>
                    </div>

                </div>
                <!-- /.modal-content -->
            </form>
        </div>
        <!-- /.modal-dialog -->
    </div>

    <style>
        .tabs-content div:not(:first-child) {
            display: none;
        }

        #online {
            height: 39px;
            font-size: 17px;
            text-align: center;
            padding: 10px;
        }

        .processing {
            position: fixed;
            height: 100vh;
            width: 100vw;
            background: rgba(0, 0, 0, .5);
            z-index: 999;
            color: #fff;
            text-align: center;
            padding-top: 10%;
        }
    </style>
@endsection

@section('ajax')
    <script type="text/javascript">
        $(document).ready(function() {

            $('.tabs-nav a').click(function() {

                // Check for active
                $('.tabs-nav li').removeClass('active');
                $('.tabs-nav li a').removeClass('active');
                $(this).parent().addClass('active');

                // Display active tab
                let currentTab = $(this).attr('href');
                $('.tabs-content div').hide();
                $(currentTab).show();

                return false;
            });

        });

        $(function() {
            $('#reset').click(function() {
                $('#result').html('');
                $('#show_hide').hide();

            });
            $('#searchBtn').on('click', function(e) {
                e.preventDefault();
                $.ajax({
                    type: 'get',
                    url: '{{ route('getClientInfo') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('#result').html(result);

                    }
                });
            });

            $('#details').on('click', function(e) {
                $('#search').append('<p class="processing">Processing....</p>');
                e.preventDefault();
                $.ajax({
                    type: 'get',
                    url: '{{ route('getClientInfo') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('.processing').remove();
                        $('#result').html(result);

                    }
                });
            });

            $(document).on('click', '.clickDetails', function() {
                id = $(this).data('id');
                 $('#show_hide').hide();
                 $('#search').append('<p class="processing">Processing....</p>');
                details(id);

            });



        });




        function details(id) {

            $.ajax({
                type: 'get',
                url: '{{ route('getClientById') }}',
                data: {
                    id: id
                },
                success: function(result) {
                    // console.log('result', result.r);

                    $('.processing').remove();
                    $("body #show_hide").show();

                    if (result.last_online == null) {
                        $('body #onlineUser').html('<a class="btn btn-danger btn-block">Ofline</a>');
                        $('#last_logout').text('');
                    } else {
                        $('body #onlineUser').html(
                            '<a class="label label-success bg-success p-2 rounded btn-block copy" >Online and IP is: <span id="OnlineIP">' +
                            result.last_online.framedipaddress + '</span></a>');
                        $('body #last_logout').val(result.last_online.acctstoptime);
                    }

                    $('body #c_name').val(result.r.clientsinfo.clients_name);
//token
                    // $('body #c_token').val(result.r.customer_token.token);

                    if (result.r.customer_account != null) {
                        $('body #totaldue').val(result.r.customer_account.dueAmount);
                    }
                    if (result.r.customer_token == null) {
                        $('body #token_output').html('');
                        $('body #previous_token_output').html('');
                    }

                    $('body #c_email').val(result.r.clientsinfo.email);
                    $('body #c_contact_no').val(result.r.clientsinfo.contact_no);
                    $('body #national_id').val(result.r.clientsinfo.national_id);
                    $('body #passport_no').val(result.r.clientsinfo.passport_no);
                    $('body #father_name').val(result.r.clientsinfo.father_name);
                    $('body #mother_name').val(result.r.clientsinfo.mother_name);
                    // $('#customer_since').val(result.r.created_at.toString('yyyy-MM-dd'));
                    $('body #customer_since').val(new Date(Date.parse(result.r.created_at)).toString(
                        "yyyy-MM-dd"));
                    $('body #created_by').val(result.r.created_by_name);
                    $('body #area').val(result.r.clientsinfo.area);

                    if (result.r.clients_status == 'active') {
                        $('body #clients_status').html("<a class='btn btn-success btn-block'>" + result.r
                            .clients_status +
                            "</a>");
                    }
                    if (result.r.clients_status != 'active') {
                        $('body #clients_status').html("<a class='btn btn-danger btn-block'>" + result.r
                            .clients_status +
                            "</a>");
                    }


                    $('body #clients_id').val(result.r.clientsinfo.client_id);
                    $('body #edit_user').html("<a class='btn btn-primary btn-block' href='clients/" + result.r.clientsinfo.client_id + "/edit'>Edit</a>");
                    $('body #resync').html("<input type=hidden id=new_userid value="+result.r.userid+"  /><a id=resync_btn class='btn btn-warning btn-block'>Resync</a>");
                    $('body #deleteFrom_radacctTable').html("<input type=hidden id=id_of_user value="+result.r.userid+"  /><a id=deleteFrom_radacctTable_btn class='btn btn-dark btn-block'>Delete From Online <span class='badge badge-danger'>(If disconect didn't work)</span> </a>");
                    console.log(result.last_online);

                    // if (result.last_online == null) {
                    //     $('body #disconnect').hide();
                    // }
                    if (result.last_online != null) {
                        $('body #disconnect').html('<a href="userDisconnect/' + result.r.userid +
                            '" class="btn btn-danger btn-block">Disconnect</a>');
                    }

                    // if (!result.last_online) { // Checks for null, undefined, or falsy values
                    //     $('body #disconnect').hide();
                    // } else {
                    //     $('body #disconnect')
                    //         .show()
                    //         .html('<a href="userDisconnect/' + result.r.userid +
                    //             '" class="btn btn-danger btn-block">Disconnect</a>');
                    // }

                    $('body #activity_name').val(result.r.clients_status).change();

                    $('body #customerID').val(result.r.id);
                    $('body #customerIDShow').text(result.r.id);

                    $('body #login_attempts').html(result.login_attempts);
                    $('body #log_activities').html(result.log_activities);
                    $('body #connection_history').html(result.connection_history);
                    $('body #edit_log_history').html(result.edit_log);

                    $('body #token_output').html(result.token_output);
                    $('body #previous_token_output').html(result.previous_token_output);

                    $('body #password').val(result.r.password);
                    $('body #userid').val(result.r.userid);
                    $('body #mac').val(result.r.mac);
                    $('body #pop_id').val(result.r.pop.popname);
                    $('body #package_name').val(result.r.packages.package_name);
                    //  $('#pop_name').val(result.r.pop.popname);
                    $('body #ip_address').val(result.r.ip_address);
                    $('body #expire_date').val(result.r.expire_date.toString('YYYY-MM-DD'));
                    // console.log(result.login_attempts);
                }
            });
        }

        $(document).on('click','#resync_btn',function(e){

            var new_userid = $('#new_userid').val();
            $.ajax({
                url: '{{ route('addredcheck') }}',
                type: "POST",
                data: {
                    userid: new_userid
                },
                success: function(data) {
                    toastr.success('User sync successfully');
                }
            });
        });

        $(document).on('click','#deleteFrom_radacctTable_btn',function(e){

            var new_userid = $('#id_of_user').val();
            $.ajax({
                url: '{{ route('singleId_deleteFrom_radacctTable') }}',
                type: "GET",
                data: {
                    userid: new_userid
                },
                success: function(data) {
                   toastr.success(data.status);
                }
            });
        });
    </script>
@endsection
