 <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>


 <script type="text/javascript">
     google.charts.load("current", {
         packages: ["corechart"]
     });
     google.charts.setOnLoadCallback(drawChart);

     function drawChart() {
         var data = google.visualization.arrayToDataTable([
             ['Task', 'Hours per Day', ],
             ['Total Active Customer',
                 <?php echo e($clientCount->where('clients_status', 'active')->first()->total ?? 0); ?>,
             ],
             ['Total Deactivated Customer',
                 <?php echo e($clientCount->where('clients_status', 'deactive')->first()->total ?? 0); ?>

             ],
             ["Expired Customer", <?php echo e($clientCount->where('clients_status', 'expired')->first()->total ?? 0); ?>],
             ['Pending Customer', <?php echo e($clientCount->where('client_approval', 'pending')->first()->total ?? 0); ?>],
             ["<?php echo e(date('F Y')); ?> New Customer", <?php echo e($newClients ?? 0); ?>],
             ["<?php echo e(date('F Y')); ?> Deactivated Customer", <?php echo e($thisMonthDeactive); ?>],
         ]);

         var options = {
             title: '',
             pieHole: 0.4,
         };

         var chart = new google.visualization.PieChart(document.getElementById('customer_info'));
         chart.draw(data, options);
     }
 </script>
 <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('show-dashboard')): ?>
 <script type="text/javascript">
    google.charts.load("current", {
        packages: ["corechart"]
    });

    google.charts.setOnLoadCallback(drawStuff);

    function drawStuff() {
        var data = google.visualization.arrayToDataTable([
            ['Element', 'Tk', { role: 'style' }],
            ["Amount", <?php echo e((float) $thisMonthBillGenerate); ?>, '#3366CC'],
            ["Collection", <?php echo e((float) $thisMonthBillPaid); ?>, '#990099'],
            ["Due", <?php echo e((float) $currentMonthDue); ?>, '#FF9900'],
        ]);

        var options = {
            width: 300,
            legend: { position: 'none' },
            axes: {
                x: {
                    0: { side: 'top', label: 'Bill Collection of <?php echo e(date('F Y')); ?>' }
                }
            },
            hAxis: {
                title: 'Only Own Manager',

            },
            bar: { groupWidth: "90%" }
        };

        var chart = new google.visualization.ColumnChart(document.getElementById('accounts_info'));
        chart.draw(data, options);
    }

    window.addEventListener('resize', drawStuff); // Optional: make chart responsive
</script>
 <?php endif; ?>


 <style>
     #accounts_info {
         display: flex;
         justify-content: center;
         align-items: center;
         height: 400px;
     }

     #customer_info {
         display: flex;
         justify-content: center;
         align-items: center;
         height: 400px;

     }
 </style>
<?php /**PATH /var/www/html/abrarnetwork/radius-circle/resources/views/layout/dashboard_chart.blade.php ENDPATH**/ ?>