<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class PaymentSuccessMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */

    public $message;
    public function __construct($message)
    {
        $this->message = $message;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('customerInvoice.mail.paymentNotification', [
            'info' => $this->message,
        ])
        // ->attachData($this->attachments(), 'invoice.pdf', [
        //     'mime' => 'application/pdf',
        // ])
        ->subject('Payment Confirmation for ' .siteinfo()->name. ' Bill');
    }
}
