@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('exportListDown') }}" method="POST">
                @csrf

                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Select Manager</label>
                            <select name="reseller_id" id="reseller" class=" form-control" required>
                                <option value="">Select One</option>
                                <option value="all">All Manager</option>
                                @foreach ($reseller as $r)
                                    <option value="{{ $r->id }}">{{ $r->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <label class=""> POP Name </label>
                        <select name="pop" id="pop" class="form-control">

                        </select>
                    </div>

                    <div class="col-md-4">
                        <label class=""> Status Type </label>
                        <select name="client_status" id="status" class="form-control">
                            <option value="all">All</option>
                            <option value="active">Active</option>
                            <option value="deactive">Deactive</option>
                            <option value="disable">Disable</option>
                            <option value="expired">Expired</option>
                        </select>
                    </div>

                    <div class="col-md-12">

                        <div class="row m-3">
                            <div class="col-md-3">
                                <input class="form-check-input" type="checkbox" name="userId"
                                    value="@if ('çhecked') 1 @endif" id="userId" checked />
                                <label class="form-check-label" for="userId">UserId</label>
                            </div>
                            <div class="col-md-3">
                                <input class="form-check-input" type="checkbox" name="name"
                                    value="@if ('çhecked') 1 @endif" id="name" checked />
                                <label class="form-check-label" for="name">Name</label>
                            </div>
                            <div class="col-md-3">
                                <input class="form-check-input" type="checkbox" name="password"
                                    value="@if ('çhecked') 1 @endif" id="password" checked />
                                <label class="form-check-label" for="password">Password</label>
                            </div>
                            <div class="col-md-3">
                                <input class="form-check-input" type="checkbox" name="date"
                                    value="@if ('çhecked') 1 @endif" id="date" checked />
                                <label class="form-check-label" for="date">Joining Date / Create Date</label>
                            </div>
                            <div class="col-md-3">
                                <input class="form-check-input" type="checkbox" name="speed"
                                    value="@if ('çhecked') 1 @endif" id="speed" checked />
                                <label class="form-check-label" for="speed">Speed / Package</label>
                            </div>
                            <div class="col-md-3">
                                <input class="form-check-input" type="checkbox" name="status"
                                    value="@if ('çhecked') 1 @endif" id="status" checked />
                                <label class="form-check-label" for="status">Connection Status</label>
                            </div>
                            {{-- <div class="col-md-3">
                                <input class="form-check-input" type="checkbox" name="llogout"
                                    value="@if ('çhecked') 1 @endif" id="llogout" checked />
                                <label class="form-check-label" for="llogout">Last Logout</label>
                            </div> --}}
                            <div class="col-md-3">
                                <input class="form-check-input" type="checkbox" name="remarks"
                                    value="@if ('çhecked') 1 @endif" id="remarks" checked />
                                <label class="form-check-label" for="remarks">Remarks</label>
                            </div>

                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="form-group float-right mt-2">
                            <button class="btn btn-primary" type="submit"><i class="fas fa-file-excel"></i> Export To
                                Excel</button>
                            <button class="btn btn-info" type="reset" id="reset">Reset</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection


@section('ajax')
    <script type="text/javascript">
        $(function() {

            $('#reset').click(function() {
                // $('#reseller').html('');
                $('#reseller').window.location.reload();
                $('#pop').html('<option value="all">ALL POP</option>');
            });

            $('#reseller').on('change', function(e) {
                e.preventDefault();
                $('body').append('<div class="hidden" id="loading">Loading.....</div>');
                $.ajax({
                    type: 'get',
                    url: '{{ route('getResellerPopList') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#pop').html(result);
                        $('#loading').remove();

                    }
                });
            });
        });
    </script>
@endsection
