 <section class="detail-area bg-white shadow-sm p-3 mb-5  rounded">

    <div class="row " style="row-gap: 10px;">

        @can('dashboard-counter')
            <x-dashboardBox link="{{ route('clients.index') }}" icon="users" title="Total Clients" value="{{ $allClient }}"
                bgcolor="total-col" iconColor="colorSky" />
            <x-dashboardBox link="{{ route('activeCustomer') }}" icon="user-shield" title="Active Clients"
                value="{{ $clientCount->where('clients_status', 'active')->first()->total ?? 0 }}" bgcolor="bgBlue"
                iconColor="colorBlue" />
            <x-dashboardBox link="{{ route('deactivatedClients') }}" icon="users-slash" title="Deactive Clients"
                value="{{ $clientCount->where('clients_status', 'deactive')->first()->total ?? 0 }}" bgcolor="colorLime"
                iconColor="colorGreen" />
                <x-dashboardBox link="{{ route('list', ['type' => 'new-join']) }}"
                    icon="user-plus" title="New Clients"
                    value="{{ $newClients ?? 0 }}"
                    bgcolor="bgGray"
                    iconColor="colorGray" />

            <x-dashboardBox link="{{ route('list','disable-customer') }}" icon="users-slash" title="Disabled  Clients"
            value="{{ $clientCount->where('clients_status', 'disable')->first()->total ?? 0 }}" bgcolor="bgYellow" iconColor="bgYellow" />
            @if (checkSettings('free_client') == 'enable')
                @can('free-client')
                    <x-dashboardBox link="{{ route('freeClient') }}" icon="user-shield" title="Free Clients"
                        value="{{ $freeClient ?? 0 }}" bgcolor="bgGreen"
                        iconColor="colorGreen" />
                @endcan
            @endif


            @can('leftclient')
                @php
                    $deactiveClient = $clientCount->where('clients_status', 'deactive')->first()->total ?? 0;
                    $totalleftClient = $deactiveClient + $deleteClients;
                @endphp
                <x-dashboardBox link="{{ route('leftClient') }}" icon="user-times" title="Left Clients"
                    value="{{ $totalleftClient }}" bgcolor="bgRed" iconColor="colorPurple" />
            @endcan

            {{-- @dd($deleteClients) --}}
            <x-dashboardBox link="{{ route('list', 'expired-Clients') }}" icon="user-times" title="Expire Clients"
                value="{{ $clientCount->where('clients_status', 'expired')->first()->total ?? 0 }}" bgcolor="bgPurple"
                iconColor="colorPurple" />
            <x-dashboardBox link="{{ route('pendingCustomer') }}" icon="users-cog" title="Pending Clients"
                value="{{ $clientCount->where('client_approval', 'pending')->first()->total ?? 0 }}"
                bgcolor="pending-bill-col" iconColor="colorRed" />
            @can('show-reseller-cost')
                @if (auth()->user()->hasRole(['Reseller Admin', 'Reseller']))
                    <x-dashboardBox link="#" icon="calendar-check" title="Reseller Cost(Per day)" value="{{ resellerPerDayCost() }}"
                    bgcolor="bgGray" iconColor="colorGray" />
                @endif
            @endcan
        @endcan

        @can('dashboard-billing-info')


            <x-dashboardBox link="{{ route('bill-generate') }}" icon="calendar-check"
                title="{{ today()->format('F') }} Bill {{ today()->format('Y') }}"
                value="{{ round($thisMonthBillGenerate+$resellerCurrentMonthBill) ?? 0 }}" bgcolor="bgGray" iconColor="colorGray" />


            {{-- <x-dashboardBox link="{{ route('dashboard') }}" icon="calendar-check"
                title="Advanced Adj {{ today()->format('F') }} {{ today()->format('Y') }}"
                value="{{ round($currentMonthAdvancedPayment) ?? 0 }}" bgcolor="bgBlue" iconColor="colorYellow" /> --}}


            <x-dashboardBox link="{{ route('bill-generate') }}" icon="calendar-check"
                title="{{ today()->format('F') }} COL {{ today()->format('Y') }}"
                value="{{ round($thisMonthBillPaid) - round($currentMonthDiscount) + round($resellerCurrentMonthCollection) ?? 0 }}" bgcolor="bgYellow"
                iconColor="bgYellow" />


            <x-dashboardBox link="{{ route('paymentReport') }}" icon="calendar-check"
                title="Discount {{ today()->format('F') }}  {{ today()->format('Y') }}"
                value="{{ round($currentMonthDiscount) ?? 0 }}" bgcolor="discount-month" iconColor="bgWhite" />


            <x-dashboardBox link="{{ route('bill-generate') }}" icon="calendar-check"
                title="{{ today()->format('F') }} Due {{ today()->format('Y') }}" value="{{ ($currentMonthDue + round($resellerCurrentMonthDue)) ?? 0 }}"
                bgcolor="bgGreen" iconColor="colorGreen" />



            <x-dashboardBox link="{{ route('paymentReport') }}" icon="wallet" title="Today Bill COL" value="{{ round($todayBillCollection) ?? 0 }}" bgcolor="bg-today-col" iconColor="colorRed" />
            <x-dashboardBox link="{{ route('due-customer') }}" icon="funnel-dollar" title="Total Due" value="{{ round($total_due) ?? 0 }}" bgcolor="bgRed" iconColor="colorPurple" />
            <x-dashboardBox link="{{ route('due-customer') }}" icon="calendar-day" title="Previous Due" value="{{ round($previous_due) ?? 0 }}" bgcolor="prev-col" iconColor="colorGreen" />
        @endcan

    </div>
</section>
