<section class="card">
    <div class="card-header">
        <h1 class="card-title float-none ">
            Last 10 Payment Report
            {{ date('M') }}
            {{ date('Y') }}
        </h1>
    </div>

    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover table-responsive-lg ">
                <thead>
                    <tr>
                        <th scope="col" class="h6">Client CID</th>
                        <th scope="col" class="h6">Client Id</th>
                        <th scope="col" class="h6">Name</th>
                        <th scope="col" class="h6">Collected By</th>
                        <th scope="col" class="h6 text-left">Payment Amount</th>
                        <th scope="col" class="h6 text-left">Payment Description</th>
                        <th scope="col" class="h6">Payemnt Method</th>
                        <th scope="col" class="h6">Date Time</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($paymentReport as $payment)
                        <tr>
                            {{-- @dd($payment) --}}
                            <td><button type="button" class="btn btn-info btn-sm">CID : {{ $payment->clients->id }}</button></td>
                            <td>{{ $payment->clients->userid }}</td>
                            <td>{{ $payment->clientsinfo->clients_name }}</td>
                            <td>{{ $payment->employee->name }}</td>
                            <td>{{ $payment->paid_amount }}</td>
                            <td>{{ $payment->description }}</td>
                            <td>{{ $payment->payment_method }}</td>
                            <td style="min-width: 200px;">{{ $payment->created_at->format('M d, Y h:i a') }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>


</section>

<style>
    .card-title {
        font-size: 32px !important;
        text-align: center !important;
        letter-spacing: 0.10rem;
        font-weight: 500;
    }

    .manager-bg {
        background-color: rgb(221 214 254 / 0.05);
        --tw-text-opacity: 1;
        color: rgb(3 7 18 / var(--tw-text-opacity));
    }

    .table-data {
        background-color: rgb(255 241 242 / 0.5);
        --tw-text-opacity: 1;
        color: rgb(15 23 42 / var(--tw-text-opacity));
    }
</style>
