@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-md-12">
                    <a href="{{ route('payroll.salaryGenerate') }}" class="btn btn-success mb-4" style="float: right">All
                        Employee Salary Generate</a>
                </div>
            </div>
            <div class="table-responsive">
                <table id="dataTable" class="display table">
                    <thead class="bg-gray-50">
                        <tr>
                            <th>Employee Id</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Number</th>
                            <th>Salary</th>
                            <th>Joining Date</th>
                            <th>Salary Generate</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>

                        @foreach ($employees as $employee)
                            <tr>
                                <td>{{ $employee->id }}</td>
                                <td>{{ $employee->name }}</td>
                                <td>{{ $employee->email }}</td>
                                <td>{{ $employee->mobile_personal }}</td>
                                <td>{{ $employee->current_salary }}</td>
                                <td>{{ $employee->join_date }}</td>
                                <td>
                                    @if ($employee->salary_generate == 1)
                                        {{ 'yes' }}
                                    @else
                                        {{ 'no' }}
                                    @endif
                                </td>
                                <td>
                                    <a href="{{ route('payrollEmployee.show', $employee->id) }}"
                                        class="btn btn-info btn-sm">View</a>
                                    <a href="{{ route('payrollEmployee.edit', $employee->id) }}"
                                        class="btn btn-warning btn-sm">Edit</a>
                                    <button class="btn btn-danger view-details-btn"
                                        data-id="{{ $employee->id }}">Payment</button>
                                </td>
                            </tr>
                        @endforeach

                        <!-- More items... -->
                    </tbody>
                </table>
            </div>

        </div>
    </div>

    <!-- SalarySheet Info Modal -->
    <div class="modal fade" id="salarySheetModal" tabindex="-1" aria-labelledby="salarySheetModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="salarySheetModalLabel">Salary Sheet Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div id="salarySheetDetails">
                        <div class="text-center">
                            <span class="spinner-border text-primary d-none" id="modalLoader"></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script>
        $(document).ready(function() {
            $('.view-details-btn').click(function() {
                console.log('Button clicked');
                var salarySheetId = $(this).data('id');

                // let modal = new bootstrap.Modal(document.getElementById('salarySheetModal'));
                // modal.show();

                $('#salarySheetDetails').html(
                    '<div class="text-center"><span class="spinner-border text-primary"></span></div>'
                );

                $.ajax({
                    url: `{{ url('admin/salary-sheet') }}/${salarySheetId}`,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        var html = `
                            <form action="{{ route('employee.payment') }}" method="POST">
                                @csrf
                                <p><strong>Employee ID:</strong> <input class="form-control" type="text" id="salarySheetId" name="employee_id" value="${data.employee_id}" readonly></p>
                                <p><strong>Name:</strong> <input class="form-control" type="text" id="salarySheetName" value="${data.employee.name}" readonly></p>
                                <p><strong>Email:</strong> <input class="form-control" type="text" id="salarySheetEmail" value="${data.employee.email}" readonly></p>
                                <p><strong>Net Salary:</strong> <input class="form-control" type="text" id="salarySheetNetSalary" value="${data.salary_amount}" readonly></p>
                                <p><strong>Salary:</strong> <input class="form-control" type="text" id="salarySheetSalary" name="amount" value=""></p>
                                <button class="btn btn-success">Payment</button>
                            </form>
                        `;
                        $('#salarySheetDetails').html(html);

                        // ✅ Bootstrap 5 Modal API here
                        let modal = new bootstrap.Modal(document.getElementById(
                            'salarySheetModal'));
                        modal.show();
                    },
                    error: function() {
                        $('#salarySheetDetails').html(
                            '<p class="text-danger">Failed to load data.</p>');
                    }
                });
            });
        });
    </script>
@endsection
