<?php

namespace App\Classes\SMS;

use App\Http\Controllers\CompanyInfoController;
use App\Jobs\ResellerSendSms;
use App\Jobs\SendSmsJob;
use App\Models\CustomerAccount;

class WelcomeSms
{
    public function send($client)
    {
        if ($client->pop->bill_generate == 'yes') {

            if (checkSettings('new-user-create-sms') == 'enable') {

                // $message = getSmsMessage()->where('tamplate_name', 'welcome')->first()->tamplate_body;
                $sms_setting = json_decode(getSmsMessage()->where('tamplate_name', 'welcome')->first()->tamplate_body, true);
                $sms_send = $sms_setting["sendsms"];
                $message = $sms_setting["sms_body"];

                $due = CustomerAccount::whereClient_id($client->id)->first()->dueAmount ?? 0;
                $companyName = siteinfo()->name;
                $companyNumber = siteinfo()->mobile;
                $link = new  CompanyInfoController();

                $message = str_replace(
                    [
                        '{c_id}',
                        '{c_code}',
                        '{c_name}',
                        '{c_username}',
                        '{c_password}',
                        '{c_package}',
                        '{c_due}',
                        '{c_deadline}',
                        '{company_name}',
                        '{company_cell}',
                        '{payment_url}'
                    ],
                    [
                        $client->id,
                        $client->customer_code,
                        $client->clientsinfo->clients_name ?? '',
                        $client->userid,
                        $client->password,
                        $client->packages->package_name,
                        $due,
                        $client->expire_date,
                        $companyName,
                        $companyNumber,
                        $link->baseUrl() . $client->slug
                    ],
                    $message
                );

                $contact = $client->clientsinfo->contact_no;
                $data = [
                    'contact_no' => $contact,
                    'message' => $message,
                    'type'    => 'New Registration'
                ];
                SendSmsJob::dispatch($data);
            }
        }
    }

    public function sendOtherReseller($client, $gatway, $reseller_name, $reseller_cell, $message, $reseller_id)
    {
        $due = CustomerAccount::whereClient_id($client->id)->first()->dueAmount ?? 0;
        $link = new  CompanyInfoController();

        $message = str_replace(
            [
                '{c_id}',
                '{c_code}',
                '{c_name}',
                '{c_username}',
                '{c_password}',
                '{package_name}',
                '{package_price}',
                '{c_expire_date}',
                '{reseller_name}',
                '{reseller_mobile}',
                '{c_package}',
                '{c_due}',
                '{c_deadline}',
                '{payment_url}'
            ],
            [
                $client->id,
                $client->customer_code,
                $client->clientsinfo->clients_name ?? '',
                $client->userid,
                $client->password,
                $client->packages->package_name,
                $client->packages->package_rate,
                $client->expire_date,
                $reseller_name,
                $reseller_cell,
                $client->packages->package_name,
                $due,
                $client->expire_date,
                $link->baseUrl() . $client->slug
            ],
            $message
        );


        $contact = $client->clientsinfo->contact_no;
        $data = [
            'reseller_id' => $reseller_id,
            'contact' => $contact,
            'message' => $message,
            'type' => "New Registration",
            'api' => $gatway

        ];
        ResellerSendSms::dispatch($data);
    }
}
