<?php

namespace App\Http\Controllers;

use App\Jobs\ResellerClientBillPaymentSyncJob;
use App\Jobs\ResellerClientMonthlyBillGenerateJob;
use App\Models\Client;
use App\Models\Pop;
use App\Models\Reseller;
use App\Models\ResellerBillGenerate;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ResellerBillGenerateController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\ResellerBillGenerate  $resellerBillGenerate
     * @return \Illuminate\Http\Response
     */
    public function show(ResellerBillGenerate $resellerBillGenerate)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\ResellerBillGenerate  $resellerBillGenerate
     * @return \Illuminate\Http\Response
     */
    public function edit(ResellerBillGenerate $resellerBillGenerate)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\ResellerBillGenerate  $resellerBillGenerate
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ResellerBillGenerate $resellerBillGenerate)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\ResellerBillGenerate  $resellerBillGenerate
     * @return \Illuminate\Http\Response
     */
    public function destroy(ResellerBillGenerate $resellerBillGenerate)
    {
        //
    }

    public function generateMonthlyBill($bill_month = null)
    {
        $resellersIds = Reseller::where('reseller_type','other')->pluck('id');
        $pops_id = Pop::whereIn('reseller_id', $resellersIds)->pluck('id');

            Client::with('pops','subpack','packages')
                    ->where('clients_status', '!=', 'deactive')
                    ->where('clients_status', '!=', 'close')
                    ->where('is_free', '!=', '1')
                    ->whereIn('pop_id', $pops_id)
                    ->select('id', 'expire_date', 'package_id', 'parmanent_discount')
            ->chunk(100, function ($clients) use ($bill_month) {
                ResellerClientMonthlyBillGenerateJob::dispatch($clients, $bill_month);
            });


    }

    public function billGenerateResellerClient(Request $request)
    {
        $clients = Client::with('pops','subpack','packages')->where('id',$request->id)->get();
        ResellerClientMonthlyBillGenerateJob::dispatch($clients,now());

        Toastr::success('Bill Generate Successfully');
        return redirect()->back();
    }

    public function addBillOtherResellerCustomer(Request $request)
    {
        try {
            DB::transaction(function () use ($request) {
                $client = Client::with('pops')->find($request->client_id);

                $resellerBillGenerate = new ResellerBillGenerate();
                $resellerBillGenerate->reseller_id = $client->pops->reseller_id;
                $resellerBillGenerate->client_id = $request->client_id;
                $resellerBillGenerate->amount = $request->amount;
                $resellerBillGenerate->paid_amount = 0;
                $resellerBillGenerate->due_amount = 0;
                $resellerBillGenerate->description = $request->description. ' by '. ' '.auth()->user()->name;
                $resellerBillGenerate->type = 'other';
                $resellerBillGenerate->save();


                if($client->customer_account_balance_reseller < 0){
                    ResellerClientBillPaymentSyncJob::dispatch($client->id);
                }

                $client->customer_account_balance_reseller = $client->customer_account_balance_reseller + $request->amount;
                $client->save();


            });
            Toastr::success('Bill Generate Successfully');
            return redirect()->back();

        }catch (\Exception $e) {

            Toastr::error('Something went wrong');
            return redirect()->back();
        }
    }
}
