@extends('layout.app')


@section('content')
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Horizontal Form -->
                    <div class="card card-primary">
                        <div class="card-header bg-light">

                            <h3 class="card-title" style="color:#115548;">Edit Expense</h3>
                            <div class="card-tools">
                                <a href="{{ route('expense.index') }}"><button class="btn btn-sm btn-primary"><i
                                            class="fa fa-list" aria-hidden="true"></i> &nbsp;See List</button></a>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        {{-- 'model'=> $model --}}
                        <!-- form start -->
                        <form method="POST" action="{{ route('expense.update', $model->id) }}"
                            enctype="multipart/form-data" name="editForm">
                            @method('put')
                            @csrf

                            <div class="card-body">
                            <div class="row">
                                <div class="form-group col-md-4">
                                    <label for="shortname">
                                        Name*
                                    </label>
                                    <input type="text" name="name" class="form-control" placeholder="Enter Name"
                                        value="{{ $model->name }}" required>
                                </div>
                                <div class="form-group col-md-4">
                                    <label for="shortname">
                                        Expense Head*
                                    </label>
                                    <select name="expenseHead" class="form-control" required>
                                        <option value="">Select One</option>
                                        @foreach ($expenseHead as $item)
                                            <option value="{{ $item->id }}">{{ $item->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-md-4">
                                    <label for="employee_id">Employee</label>
                                    <select name="employee_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach (getEmployesInExpense() as $item)
                                            <option value="{{ $item->id }}" {{ $item->id == $model->employee_id ? 'selected' : '' }}>{{ $item->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-md-4">
                                    <label for="shortname">
                                        Invoice Number*
                                    </label>
                                    <input type="text" name="invoice_number" class="form-control"
                                        placeholder="Enter Invoice Number" value="{{ $model->invoice_number }}" required>
                                </div>
                                <div class="form-group col-md-4">
                                    <label for="shortname">
                                        Date*
                                    </label>
                                    <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                        <input type="text" placeholder="Enter Date" name="date" value="{{ date('m/d/Y',strtotime($model->date)) }}"
                                            class="form-control datetimepicker-input input-group-append" data-toggle="datetimepicker"
                                            data-target="#searchFrom" autocomplete="off" >

                                    </div>

                                </div>

                                <div class="form-group col-md-4">
                                    <label for="shortname">
                                        Amount*
                                    </label>
                                    <input type="number" step=".01" name="amount" class="form-control" placeholder="Enter Amount" value="{{ $model->amount }}" required>
                                </div>
                                <div class="form-group col-md-4">

                                    <label for="Attachment" class="control-label">Upload Documents</label>
                                    <input placeholder="Upload Attachment" class="form-control" name="attach_document"
                                        type="file" autocomplete="off">


                                    @if ($model->attach_document != null)

                                        <img src="{{ asset('storage/expenseDocument/' . $model->attach_document) }}"
                                            style="width: 100px; height:100px;">
                                        {{-- <iframe
                                            src="{{ asset('storage/attachDocument/' . $model->attach_document) }}"></iframe> --}}
                                        <input type="hidden" name="id" value="{{ $model->id }}">
                                    @else
                                        <input type="hidden" name="id" value="{{ $model->id }}">
                                    @endif

                                </div>

                                <div class="form-group col-md-12">
                                    <label for="shortname">
                                        Description*
                                    </label>
                                    <textarea name="description" class="form-control"
                                        placeholder="Type Description"> {{ $model->description }}</textarea>
                                </div>
                            </div>
                                <div class="form-group float-right">
                                    <button type="submit" name="btn" class=" btn btn-primary">Update</button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.card -->
                </div>
                <div class="col-2"></div>
            </div>
            <!-- /.row -->

        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
    <script>
        document.forms['editForm'].elements['expenseHead'].value = {{ $model->expenseHead }}
    </script>
@endsection
@push('script-bottom')


@endpush
