@extends('layout.app')

@section('content')
    <form action="{{ route('marketing-user.update', $data->id) }}" method="POST">
        @method('PUT')
        @csrf

        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="form-group col-md-6">
                        <label for="mfname" class="block text-sm font-medium text-gray-700">
                            First Name*
                        </label>
                        <input type="text" id="mfname" name="mfname" value="{{ $data->firstname }}"
                            class="form-control" placeholder="First Name" required>
                        @error('mfname')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                    <div class="form-group col-md-6">
                        <label for="mlname" class="block text-sm font-medium text-gray-700">
                            Last Name*
                        </label>
                        <input type="text" id="mlname" name="mlname" value="{{ $data->lastname }}"
                            class="form-control" placeholder="Last Name" required>
                        @error('mlname')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                    <div class="form-group col-md-6">
                        <label for="contact_no" class="block text-sm font-medium text-gray-700">
                            Contact No*
                        </label>
                        <input type="text" id="marketercontact" name="contact_no" value="{{ $data->contact_no }}"
                            class="form-control" placeholder="01234567891" required>
                        @error('contact_no')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>

                <div class="modal-footer">
                    <button class="btn btn-primary" type="submit">Save</button>
                </div>
            </div>
        </div>
    </form>
@endsection
