import React, { useEffect } from 'react';
import { Container, Table } from 'react-bootstrap';
import CableMappingRow from './CableMappingRow';

const CableMapping = (props) => {
  const { cableMap, cableType, fiberCount, setCableMap, tubeCount } = props;

  useEffect(() => {
    if (isNaN(tubeCount) || isNaN(fiberCount)) return;

    const arrayOfCableTubes = [];
    for (let tube = 1; tube <= tubeCount; tube++) {
      const tubeInfo = { tube_number: tube, fibers: [] };
      for (let fiber = 1; fiber <= fiberCount; fiber++) {
        tubeInfo.fibers.push({ fiber_number: fiber, parent_fiber_id: null });
      }
      arrayOfCableTubes.push(tubeInfo);
    }
    setCableMap(() => arrayOfCableTubes);
  }, [cableType, fiberCount, setCableMap, tubeCount]);

  return (
    <Container>
      <h4 className='text-center'>Fiber Mapping Section</h4>
      <Table striped hover>
        <thead>
          <tr>
            <th>Current Tube</th>
            <th>Current Fiber</th>
            <th>Parent Tube</th>
            <th>Parent Fiber</th>
          </tr>
        </thead>
        <tbody>
          {cableMap.map((tube) => (
            <CableMappingRow tube={tube} setCableMap={setCableMap} />
          ))}
        </tbody>
      </Table>
    </Container>
  );
};

export default CableMapping;
