@extends('layout.app')

@section('content')
    <h4>Onu's information</h4>

    <div class="container-fluid bg-white my-3 py-2 shadow-sm">
        <p>Total: {{ $devices->count() }}</p>
        <table id="devicesTable" class="display">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>OLT Address</th>
                    <th>OLT Name</th>
                    <th>Username</th>
                    <th>ONU ID</th>
                    <th>MAC</th>
                    <th>VLAN</th>
                    <th>Interface</th>
                    <th>Laser(Power)</th>
                    <th>Updated At</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($devices as $device)
                    <tr>
                        <td>{{ $device->id }}</td>
                        <td>{{ $device->oltaddress }}</td>
                        <td>{{ $device->oltName }}</td>
                        <td>{{ $device->username }}</td>
                        <td>{{ $device->onuid }}</td>
                        <td>{{ strtoupper(implode(':', str_split($device->mac, 2))) }}</td>
                        <td>{{ $device->Vlan }}</td>
                        <td>{{ $device->interface }}</td>
                        <td>{{ $device->laser }}</td>
                        <td>{{ $device->updated_at }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@endsection


@section('ajax')
    <script>
        $(document).ready(function() {
            $('#devicesTable').DataTable({
                "order": [
                    [7, "desc"]
                ],
                "pageLength": 50
            });
        });
    </script>
@endsection
