@extends('layout.app')

@section('content')
    <div class="card">
        
        <div class="card-body">
            <div class="float-right">
                {{ $lists->links() }}
            </div>
            <div class="table-responsive">
                <table class="display table table-sm table-bordered table-striped">
                    <thead class="bg-gray-50">
                        <tr class="bg-black">
                            <th scope="col">
                                Id
                            </th>
                            <th scope="col">
                                Date
                            </th>
                            <th scope="col">
                                Client
                            </th>
                            <th scope="col">
                                To
                            </th>
                            <th scope="col">
                                Subject
                            </th>
                            <th scope="col">
                                status
                            </th>
                            <th scope="col">
                                Error Log
                            </th>

                            <th scope="col">
                                Message
                            </th>
                        </tr>
                    </thead>
                    <tbody>

                        @foreach ($lists as $item)
                            <tr>
                                <td>
                                    {{ $item->id }}
                                </td>
                                <td>
                                    {{ $item->created_at }}
                                </td>
                                <td>
                                    {{ $item->clients->userid ?? '' }}
                                </td>
                                <td>
                                    {{ $item->to }}
                                </td>
                                <td>
                                    {{ $item->subject }}
                                </td>
                                <td>
                                    {{ $item->status }}
                                </td>
                                <td style="max-width:200px">
                                    {{ $item->error }}
                                </td>
                                <td>
                                    {!! $item->message !!}
                                </td>
                            </tr>
                        @endforeach

                        <!-- More items... -->
                    </tbody>
                </table>
            </div>
        </div>
        <div class="card-footer">
            {{ $lists->links() }}

        </div>
    </div>
@endsection
