import { useSelector } from 'react-redux';
import ClusterCreate from './SubmitForms/ClusterCreate/ClusterCreate';
import useEditablePolyline from '../../hooks/useEditablePolyline';
import CableCreate from './SubmitForms/CableCreate/CableCreate';
import { Modal, Tab, Tabs } from 'react-bootstrap';
import TjBoxCreate from './SubmitForms/TjBoxCreate/TjBoxCreate';

const SubmitForm = ({ show, handleClose }) => {
  const parent = useSelector((state) => state.coordinatesReducer.startNode);
  const { coordinates } = useEditablePolyline();
  if (!parent && coordinates.length === 1) {
    return (
      <Modal show={show} onHide={handleClose}>
        <Modal.Body className='p-2'>
          <Tabs
            defaultActiveKey='cluster'
            transition={true}
            className='mb-1'
            fill
          >
            <Tab eventKey='cluster' title='Cluster'>
              <ClusterCreate show={show} handleClose={handleClose} />
            </Tab>
            <Tab eventKey='tjBox' title='TJ Box'>
              <TjBoxCreate show={show} handleClose={handleClose} />
            </Tab>
          </Tabs>
        </Modal.Body>
      </Modal>
    );
  } else if (parent && coordinates.length > 0) {
    return <CableCreate show={show} handleClose={handleClose} />;
  }
  handleClose();
  return null;
};

export default SubmitForm;
