@can('dashboard-billing-info')

    @if (checkSettings('reseller_bill_collection'))
        <section class="bill-collection-area bg-white pt-2 px-4 mt-2 mb-2 pb-2">
            <h4 class="text-center my-2">Other Manager Bill Collection
                {{ date('M') }} {{ date('Y') }}</h4>
            <table class="table table-hover table-responsive-lg">
                <thead>
                    <tr>
                        <th scope="col" class="h6">Pop Name</th>
                        <th scope="col" class="h6 text-right">Approximate Bill</th>
                        <th scope="col" class="h6 text-right">Previous Month Bill Collection</th>
                        <th scope="col" class="h6 text-right">This Month Bill Collection</th>

                    </tr>
                </thead>
                <tbody>
                    @php
                        $amounts = 0;
                        $client_total_bill = 0;
                        $amounts_previous = 0;
                    @endphp

                    @foreach ($pops as $item)
                        @php
                            $sum = 0;
                            $sum_package = 0;
                            $sum_previous = 0;
                            foreach ($item->clients as $client) {
                                $sum += $client->resellerBlanceLogCurrentMonth->sum('amount');
                                $sum_package += $client->packages->package_rate;
                                $sum_previous += $client->resellerBlanceLogPreviousMonth->sum('amount');
                            }
                        @endphp
                        <tr>
                            <td class="h6">
                                {{ $item->popname }}
                            </td>
                            <td class="text-right">{{ $sum_package }}</td>
                            <td class="text-right">{{ $sum_previous }}</td>
                            <td class="text-right">{{ $sum }}</td>
                        </tr>

                        @php
                            $amounts += $sum;
                            $client_total_bill += $sum_package;
                            $amounts_previous += $sum_previous;
                        @endphp
                    @endforeach

                    <tr class="bg-gray">
                        <td class="h6">Total</td>
                        <td class="h6 text-right">{{ $client_total_bill }}</td>
                        <td class="h6 text-right">{{ $amounts_previous }}</td>
                        <td class="h6 text-right">{{ $amounts }}</td>


                    </tr>
                </tbody>
            </table>
        </section>
    @endif
@endcan



