<?php

namespace App\Exports;

use Carbon\Carbon;
use PhpOffice\PhpSpreadsheet\Shared\Date;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;

class ClientExportNew implements FromCollection, WithHeadings, ShouldAutoSize, WithColumnFormatting
{
    public function headings(): array
    {
        return [
            'client_type',
            'connection_type',
            'client_name',
            'bandwidth_distribution_point',
            'connectivity_type',
            'activation_date',
            'bandwidth_allocation',
            'allocated_ip',
            'division',
            'district',
            'thana',
            'address',
            'client_mobile',
            'client_email',
            'selling_price_bdt_excluding_vat',
        ];
    }
    protected $data;

    function __construct($data)
    {
        $this->data = $data;
    }


    public function address($clientsinfo)
    {

        $client = $clientsinfo;
        $addressParts = [
            $client['building_name'],
            $client['road_no'],
            $client['block_sector'],
            $client['area'],
        ];
        return implode(', ', array_filter($addressParts));
    }

    public function collection()
    {
        $items = [];
        foreach ($this->data as $client) {


            // if ($client->clientsinfo->building_no != null) {

            //     $building = $client->clientsinfo->building_no ?? '';
            //     if ($address != "") {
            //         $address = $address .  ', house-' . $building;
            //     } else {
            //         $address = $address .  'house-' . $building;
            //     }
            // }

            // if ($client->clientsinfo->road_no != null) {

            //     $road = $client->clientsinfo->road_no ?? '';
            //     if ($building != "") {

            //         $address = $address .  ', road-' . $road;
            //     } else {

            //         $address = $address .  'road-' . $road;
            //     }
            // }

            // if ($client->clientsinfo->area != null) {
            //     if ($address != "") {
            //         $address = $address .  ', area-' . $client->clientsinfo->area ?? '';
            //     } else {

            //         $address = $address . 'area-' . $client->clientsinfo->area ?? '';
            //     }
            // }

            $package_rate = $client->packages->btrc_package_price;



            if($package_rate == 0){
                $package_rate = $client->packages->package_rate  == 0 ? 500 : $client->packages->package_rate;
                // dd($client);
            }
            $distribution = '';
            $connection = '';
            if($client->distribution_point == 'pop'){
                $distribution = 'PoP';
            }
            if($client->distribution_point == 'noc'){
                $distribution = 'NOC';
            }
            if($client->connection_type == 'shared'){
                $connection = 'Shared';
            }
            if($client->connection_type == 'dedicated'){
                $connection = 'Dedicated';
            }
            $items[] = [
                $client->customer_type,
                'Wired',
                $client->clientsinfo->clients_name,
                $distribution != '' ? $distribution : 'NOC',
                $connection != '' ? $connection : 'Shared',
                $client->created_at ? Date::dateTimeToExcel(Carbon::parse($client->created_at)) : '',
                $client->packages->package_bandwidth ??  $client->packages->package_name ?? '',
                $client->ip_address ?? $client->pops->nas->nasname,
                $client->clientsinfo->divisions->name ?? $client->clientsinfo->division ?? '',
                $client->clientsinfo->districts->name ?? $client->clientsinfo->district ?? '',
                $client->clientsinfo->thanas->name ?? $client->clientsinfo->upazilas->name ?? '',
                $this->address($client->clientsinfo),
                $client->clientsinfo->contact_no ?? '',
                $client->clientsinfo->email ?? '',
                $package_rate ?? '',
            ];
        }

        ob_end_clean();
        return collect($items);
    }

    public function columnFormats(): array
    {
        return [
            'F' => 'dd-mm-yy',
        ];
    }
}
