<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOtcPaymentLogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('otc_payment_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('client_id');
            $table->foreignId('bill_id');
            $table->foreignId('payment_id');
            $table->decimal('otc_payment', 10, 2)->default(0);
            $table->decimal('otc_discount', 10, 2)->default(0);
            $table->dateTime('otc_payment_date')->nullable();
            $table->foreignId('employee_id')->nullable();
            $table->foreignId('admin_user_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('otc_payment_logs');
    }
}
