<?php

namespace App\Console\Commands;

use App\Jobs\AutoDeactiveJob;
use App\Models\Client;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class CheckAutoDeactive extends Command
{

    protected $signature = 'check:auto-deactive';

    protected $description = 'Auto Deactive Check';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        // Log::info("log -check:auto-deactive");

        $this->info("start to check auto deactive \n");
        if (checkSettings('auto_deactive_check') == 'enable') {
            $currentDate = Carbon::now();
            Client::with('packages')->where('clients_status', '!=', 'deactive')->where('clients_status', '!=', 'close')
                ->where('auto_deactive', '<=', $currentDate)
                ->select('id', 'userid', 'auto_deactive')
                ->chunk(100, function ($clients) {
                    AutoDeactiveJob::dispatch($clients);
                });
        }
        $this->info("End to check auto deactive \n");
    }
}
