<?php

namespace App\Console\Commands;

use App\Models\Client;
use App\Models\CustomerDelInfo;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class DeleteAllCloseCustomerCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'delete:all-close-customer';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

        $clients = Client::withTrashed()->where('deleted_at', '!=', null)->get();
       
        foreach ($clients as $client) {

                $deleted = new CustomerDelInfo();
                $deleted->customer_id = $client->id;
                $deleted->username = $client->userid;
                $deleted->deleted_by = 1;
                $deleted->save();

                DB::statement("delete from clientsinfo where client_id=$client->id");
                DB::statement("delete from clients where id=$client->id");

        }
    }
}
