<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class DevController extends Controller
{
    public function index()
    {
        // if user id 1 then only access this page
        if (auth()->id() !== 1) {
            return redirect()->route('home');
        }

        $server_ip = request()->server('SERVER_ADDR');
        $base_path = base_path();
        $page_title = 'Dev Mode';
        $ssh_server_ip = env('SSH_SERVER_IP') ?? "shimul.yetfix.com:5050";
        return view('dev.index', compact('server_ip', 'base_path', 'page_title', 'ssh_server_ip'));
    }
}
