
@php($permissions = userPermissions())
@extends('layout.app')

@section('content')

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title" style="color:#115548;"><i class="fa fa-search"></i> Missing Monthly Bill Generate Report
                            </h3>
                        </div>

                        <div class="card-body">

                            <form action="" id="search">
                                <div class="row">

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                                From Date
                                            </label>
                                            <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                                <input type="text" name="from_date" value="{{$start->format('m/d/y')}}" class="form-control datetimepicker-input input-group-append"
                                                    data-toggle="datetimepicker" data-target="#searchFrom" autocomplete="off">

                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="block text-gray-700 text-sm font-bold mb-2" for="to_date">
                                                To Date
                                            </label>
                                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                                <input type="text" name="to_date" value="{{$end->format('m/d/y')}}"
                                                    class="form-control datetimepicker-input input-group-append"  data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3">
                                        <div class="form-group">
                                            <label class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'>Select
                                                Manager</label>
                                            <select name="reseller_id" id="reseller_id" class="select2 form-control">
                                                <option value="">All Reseller</option>
                                                @foreach ($reseller as $r)
                                                    <option value="{{ $r->id }}">{{ $r->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3">
                                        <div class="form-group">
                                            <label class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'>Select
                                                Sub-Manager/Pop</label>
                                            <select name="pop_id" id="pop" class="select2 form-control">
                                                <option value="">All Pops/Sub-manager</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="form-group float-right mt-2">
                                            <button class="btn btn-primary" type="submit" id="searchBtn"><i class="fa fa-search"></i> Search</button>
                                        </div>
                                    </div>


                                </div>
                            </form>
                            <br>
                            <div class="col-md-12" id="result">
                                <button class="btn btn-primary mb-2" onclick="export2csv()">Download csv</button>
                                <table class="table table-striped table-borderless table-condensed" id="result_table">
                                    <thead>
                                        <tr class="bg-black">
                                            <th>ID</th>
                                            <th>User name</th>
                                            <th>Status</th>
                                            <th>Expire</th>
                                            <th>Package</th>
                                            <th>Package Price</th>

                                            <th>POP</th>
                                            <th>Name</th>
                                            <th>Contact</th>
                                            <th>Client Info</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                            @foreach ($clients as $r)
                                            <tr >

                                                <td class="text-center">
                                                    <a class=" btn-info btn-block btn-xs text-nowrap clear"
                                                            href="{{ route('getPaymentHistory', $r->id) }}">CID: {{ $r->id }}</a>
                                                </td>
                                                <td class="no-wrap">
                                                    {{ $r->userid }}

                                                </td>

                                                <td class="cStatus{{ $r->id }} {{ clientStatusClass($r->clients_status) }} ">

                                                    @if ($r->clients_status == 'active')
                                                        Active
                                                    @elseif($r->clients_status == 'deactive')
                                                        Deactive</span>
                                                    @elseif($r->clients_status == 'expired')
                                                        Expired</span>
                                                    @elseif($r->clients_status == 'disable')
                                                        Disabled</span>
                                                    @endif

                                                </td>
                                                <td class="cExpireDate{{ $r->id }} {{ clientStatusClass($r->clients_status) }}"
                                                    style="min-width:140px;text-align:left">
                                                    BD: {{ date('d-M-Y', strtotime($r->expire_date)) }}<br>
                                                    @if ($r->payment_dadeline != 0)
                                                        <span class="d-block badge badge-warning">
                                                            PD: {{ \Carbon\Carbon::parse($r->expire_date)->addDay($r->payment_dadeline)->format('d-M-Y') }}
                                                        </span>
                                                    @else
                                                            PD: {{ \Carbon\Carbon::parse($r->expire_date)->addDay($r->payment_dadeline)->format('d-M-Y') }}
                                                    @endif
                                                </td>


                                                <td>

                                                    @if (in_array('show-sub-package', $permissions))
                                                        <span class="d-block mb-1 badge badge-info">{{ $r->subpack->name ?? '' }} </span>
                                                    @endif


                                                    @if (in_array('show-mother-package', $permissions))
                                                        <span class="d-block badge badge-info"> {{ $r->packages->package_name ?? '' }} </span>
                                                    @endif

                                                </td>

                                                <td>
                                                    @if (in_array('show-sub-package', $permissions)) Sub package price :  {{ $r->subpack->rate ?? '0.00' }}   @endif
                                                    <br>  @if (in_array('show-mother-package', $permissions)) Package price :  {{ $r->packages->package_rate ?? '0.00' }} @endif
                                                    <br> Permanent Discount: {{ $r->parmanent_discount ?? '0.00' }}
                                                    <br>  @if ($r->is_free == 1)
                                                            <p class="badge badge-info m-0">Free</p>
                                                        @endif

                                                </td>

                                                <td class="no-wrap">
                                                    @if ($r->pops->experity_check == 'Yes')
                                                        <span class="d-block badge badge-warning">
                                                            {{ $r->pops->popname ?? '' }}
                                                        </span>
                                                    @else
                                                        {{ $r->pops->popname ?? '' }}
                                                    @endif
                                                </td>

                                                <td>
                                                    {{ $r->clientsinfo->clients_name ?? '' }}
                                                </td>
                                                <td>
                                                    {{ $r->clientsinfo->contact_no ?? '' }}
                                                </td>



                                                <td style="width:350px;font-size:14px">
                                                    @if ($r->ip_address)
                                                        IP: {{ $r->ip_address ?? '' }},
                                                    @endif
                                                    @if ($r->clientsinfo->flat_no)
                                                        Flat No: {{ $r->clientsinfo->flat_no ?? '' }},
                                                    @endif
                                                    @if ($r->clientsinfo->building_name)
                                                        Building Name: {{ $r->clientsinfo->building_name ?? '' }},<br>
                                                    @endif
                                                    @if ($r->clientsinfo->building_no)
                                                        Building No: {{ $r->clientsinfo->building_no ?? '' }},<br>
                                                    @endif
                                                    @if ($r->clientsinfo->road_name)
                                                        Road Name: {{ $r->clientsinfo->road_name ?? '' }},<br>
                                                    @endif
                                                    @if ($r->clientsinfo->road_no)
                                                        Road No: {{ $r->clientsinfo->road_no ?? '' }},<br>
                                                    @endif
                                                    @if ($r->clientsinfo->block_sector)
                                                        Block/Sector: {{ $r->clientsinfo->block_sector ?? '' }},<br>
                                                    @endif
                                                    @if ($r->clientsinfo->area)
                                                        Area :{{ $r->clientsinfo->area ?? '' }},<br>
                                                    @endif
                                                    @if ($r->clientsinfo->box)
                                                        Box :{{ $r->clientsinfo->box ?? '' }},<br>
                                                    @endif
                                                    @if ($r->clientsinfo->cable_type)
                                                        Cable Type :{{ $r->clientsinfo->cable_type ?? '' }},<br>
                                                    @endif
                                                    @if ($r->clientsinfo->olt_pon)
                                                        OLT/PON : {{ $r->clientsinfo->olt_pon ?? '' }},<br>
                                                    @endif
                                                    @if ($r->clientsinfo->other_contact)
                                                        Other Contact : {{ $r->clientsinfo->other_contact ?? '' }},<br>
                                                    @endif
                                                    @if ($r->clientsinfo->email)
                                                        <br>
                                                        <b class="text-primary">Email :</b> {{ $r->clientsinfo->email ?? '' }},<br>
                                                    @endif
                                                    @if ($r->clientsinfo->client_latitude)
                                                        Latitude : {{ $r->clientsinfo->client_latitude ?? '' }},<br>
                                                    @endif

                                                    @if ($r->clientsinfo->client_longitude)
                                                        Longitude : {{ $r->clientsinfo->client_longitude ?? '' }},<br>
                                                    @endif


                                                    @if ($r->required_cable)
                                                        Cable(Meter): {{ $r->required_cable ?? '' }},<br>
                                                    @endif
                                                    @if ($r->clientsinfo->cat_length)
                                                        CAT-5/CAT-6 Length(Meter): {{ $r->clientsinfo->cat_length ?? '' }},<br>
                                                    @endif
                                                    @if ($r->clientsinfo->onu_serial)
                                                        ONU MAC/Pon No/Serial No: {{ $r->clientsinfo->onu_serial ?? '' }},<br>
                                                    @endif
                                                    @if ($r->clientsinfo->olt_pon)
                                                        OLT No: {{ $r->clientsinfo->olt_pon ?? '' }},<br>
                                                    @endif
                                                    @if ($r->clientsinfo->olt_no)
                                                        OLT Card Slot No: {{ $r->clientsinfo->olt_no ?? '' }},<br>
                                                    @endif
                                                    @if ($r->clientsinfo->pon_port)
                                                        PON Module Port No: {{ $r->clientsinfo->pon_port ?? '' }}
                                                    @endif

                                                </td>

                                            </tr>
                                            @endforeach

                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td><strong>Total</strong></td>
                                            <td><strong>{{$clients->count()}}</strong></td>
                                        </tr>
                                    </tfoot>

                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection

@section('js')

@endsection
@push('script')

@endpush

@section('ajax')
    <script type="text/javascript">
        $(document).ready(function() {
            $('#searchBtn').click(function(e) {
                e.preventDefault();
                $('body').prepend('<div id="loading">Loading.....</div>');
                $.ajax({
                    type: 'get',
                    url: '{{ route('missing-bill-generate-search') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('#result').html(result);
                        $('#loading').remove();

                    }
                });
            });
        });

        function export2csv() {
            let data = "";
            const tableData = [];
            const rows = document.querySelectorAll("table#result_table tr");
            for (const row of rows) {
                const rowData = [];
                for (const [index, column] of row.querySelectorAll("th, td").entries()) {

                    rowData.push(column.innerText.replace(/[\r\n]/gm, ' '));
                }
                tableData.push(rowData.join(","));
            }
            data += tableData.join("\n");
            const a = document.createElement("a");
            a.href = URL.createObjectURL(new Blob([data], { type: "text/csv" }));
            a.setAttribute("download", "missing_bill_generate.csv");
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }

        $('#reseller_id').on('change', function() {
            $("#loader").show();
            $.ajax({
                type: 'get',
                url: '{{ route('getPopForManager') }}',
                data: {
                    id: $(this).val()
                },
                success: function(data) {
                    $('#pop option').remove();
                    $('#pop').append(data);
                    $("#loader").hide();
                }
            });
        });

    </script>

@endsection
