@extends('layout.app')
@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('assignResellerUpdate', $user->id) }}" method="POST" id="reseller_assign_from">
                @method('PUT')
                @csrf


                <h2 class="page-header">User Name :
                    {{ $user->name }}</h2>

                @error('reseller_id')
                    <p class="w-1/2 m-auto text-center text-white bg-yellow-300 m-2 p-2">{{ $message }} </p>
                @enderror

                <table class="table" id="custom_data_table">
                    <thead class="bg-gray-50">
                        <tr>
                            <th>ID</th>
                            <th>Reseller Name</th>
                            <th>Reseller Address</th>
                            <th></th>
                        </tr>

                    </thead>
                    <tbody>
                        @foreach ($reseller as $r)
                            <tr>

                                <td>{{ $r->id }}</td>
                                <td>{{ $r->name }}</td>
                                <td>{{ $r->address }}</td>
                                <td>

                                    <div class="form-group">

                                        <div class="custom-control custom-switch">
                                            {{-- <input type="checkbox" class="custom-control-input" id="customSwitch1"> --}}

                                            <input class="custom-control-input" id="reseller{{ $r->id }}"
                                                name="reseller[]" type="checkbox" value="{{ $r->id }}"
                                                @foreach ($user->resellers as $reseller)
                              @if ($reseller->id == $r->id)
                              checked
                              @endif @endforeach>
                                            <label class="custom-control-label" for="reseller{{ $r->id }}"></label>
                                        </div>

                                    </div>



                                </td>
                            </tr>
                        @endforeach

                    </tbody>



                </table>

                <div class="form-group">
                    <a href="{{ route('user.index') }}" class="btn btn-default"><i class="fa fa-arrow-left"></i> Back</a>
                    <input type="submit" class="btn btn-primary float-right" id="assign_reseller_btn" value="Assign Reseller">
                </div>
            </form>
        </div>
    </div>
@endsection

@section('ajax')
    <script type="text/javascript">
        $(document).ready(function() {
            $('#custom_data_table').DataTable({
                responsive: true,
                "bProcessing": true,
                "iDisplayLength": 100000,
                'order': [
                    [0, "desc"]
                ]
            });
            var l = $('#custom_data_table_filter').find('input');
            l.keyup(function() {
                var value = $(this).val();
                if (value.length > 0) {
                    $('#select_all').prop('checked', false);
                }

            });

            $('#assign_reseller_btn').click(function(e) {
                e.preventDefault();
                $('#processing').show();

                $('#custom_data_table_filter').find('input').val('');
                $('#custom_data_table').DataTable().search('').draw();
                $('#reseller_assign_from').submit();
            });
        });
    </script>
@endsection
