<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class DeactiveCloseExport implements FromCollection, WithHeadings, ShouldAutoSize
{
    public function headings(): array
    {
        return [
            'ID',
            'Username',
            'password',
            'Status',
            'Expire',
            'B Cycle',
            'Package',
            'MRC',
            'OTC',
            'POP',
            'Name',
            'Contact',
            'NID',
            'Customer Info',
            'Area',
            'Cable Type',
            'C Date',
            'J Date',
            'Remarks',
            'Balance',
            'Email'
        ];
    }
    protected $data;

    function __construct($data)
    {
        $this->data = $data;
    }

    public function collection()
    {
        $items = [];
        foreach ($this->data as $client) {

            if ($client->subpack) {
                $speed = $client->subpack->name;
                $mrc = $client->subpack->rate ?? 0;
            } else {
                $speed = $client->packages->package_name;
                $mrc = $client->packages->package_rate ?? 0;
            }

            $client_info  = $client->clientsinfo->flat_no . " " ?? '';
            $client_info .= $client->clientsinfo->building_name . " " ?? '';
            $client_info .= $client->clientsinfo->building_no . " " ?? '';
            $client_info .= $client->clientsinfo->road_name . " " ?? '';
            $client_info .= $client->clientsinfo->block_sector . " " ?? '';
            $client_info .= $client->clientsinfo->box . " " ?? '';
            $client_info .= $client->clientsinfo->olt_pon . " " ?? '';

            if (isset($client->customerAccount->dueAmount)) {
                $balance = $client->pop->bill_generate == "yes" ? (string)($client->customerAccount->dueAmount) : "0";
            } else {
                $balance = "0";
            }

            $items[] = [
                $client->id,
                $client->userid,
                $client->password,
                $client->clients_status,
                $client->expire_date ? date('Y-m-d', strtotime($client->expire_date)) : '',
                $client->billing_cycle,
                $speed,
                $mrc,
                $client->clientsinfo->otc,
                $client->pop->popname,
                $client->clientsinfo->clients_name,
                $client->clientsinfo->contact_no ?? '',
                $client->clientsinfo->national_id ?? '',
                $client_info,
                $client->clientsinfo->area ?? '',
                $client->clientsinfo->cable_type ?? '',
                $client->created_at ? date('Y-m-d', strtotime($client->created_at)) : '',
                $client->clientsinfo->joinDate ? date('Y-m-d', strtotime($client->clientsinfo->joinDate)) : '',
                $client->clientsinfo->remarks ?? '',
                $balance,
                $client->clientsinfo->email ?? '',
            ];
        }
        // dd($items);
        return collect($items);
    }
}
