<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class SyncExport implements FromCollection, WithHeadings, ShouldAutoSize
{

    public function headings(): array
    {
        return [
            'Username',
            'Password',
            'Profile',
            'Comment',
            'Disable Status',
            'Static IP',
        ];
    }
    protected $data;

    function __construct($data)
    {
        $this->data = $data;
    }

    public function collection()
    {
        $items = [];
        foreach ($this->data as $client) {
            $items[] = [
                $client->username,
                $client->password,
                $client->profile_name,
                $client->mk_comment,
                $client->disable_status,
                $client->static_ip,
            ];

            // dd($items);
        }

        return collect($items);
    }
}
