<?php

namespace App\Models\map;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Device extends Model
{
    use HasFactory;

    protected $table = "device_map";
    protected $fillable = [
        "name",
        "manufactures",
        "model",
        "serial_number",
        "remarks",
        "cluster_id",
        "total_ports",
        "type"
    ];

    public function cluster()
    {
        return $this->belongsTo(Cluster::class, "cluster_id");
    }

    public function childDevices()
    {
        return $this->hasMany(Device::class, "child_component_id");
    }

    public function ports()
    {
        return $this->hasMany(Port::class, "device_id");
    }
}
