<?php

namespace App\Observers;

use App\Classes\BillgenerateUpdate;
use App\Jobs\BillGenerateUpdateJob;
use App\Models\Billpayment;

class BillPaymentObserver
{
    /**
     * Handle the Billpayment "created" event.
     *
     * @param  \App\Models\Billpayment  $billpayment
     * @return void
     */
    public function created(Billpayment $billpayment)
    {
        try{
            if(!globalPermission('payment-bill-by-bill')){
                BillGenerateUpdateJob::dispatch($billpayment->client_id);
            }

            // (new BillgenerateUpdate)->update($billpayment->client_id);
        }catch(\Exception $e){

        }


    }

    /**
     * Handle the Billpayment "updated" event.
     *
     * @param  \App\Models\Billpayment  $billpayment
     * @return void
     */
    public function updated(Billpayment $billpayment)
    {
        try{
            if(!globalPermission('payment-bill-by-bill')){
                BillGenerateUpdateJob::dispatch($billpayment->client_id);
            }
        }catch(\Exception $e){

        }

    }

    /**
     * Handle the Billpayment "deleted" event.
     *
     * @param  \App\Models\Billpayment  $billpayment
     * @return void
     */
    public function deleted(Billpayment $billpayment)
    {
        try{
            if(!globalPermission('payment-bill-by-bill')){
                BillGenerateUpdateJob::dispatch($billpayment->client_id);
            }
        }catch(\Exception $e){

        }

    }

    /**
     * Handle the Billpayment "restored" event.
     *
     * @param  \App\Models\Billpayment  $billpayment
     * @return void
     */
    public function restored(Billpayment $billpayment)
    {
        try{
            if(!globalPermission('payment-bill-by-bill')){
                BillGenerateUpdateJob::dispatch($billpayment->client_id);
            }
        }catch(\Exception $e){

        }

    }

    /**
     * Handle the Billpayment "force deleted" event.
     *
     * @param  \App\Models\Billpayment  $billpayment
     * @return void
     */
    public function forceDeleted(Billpayment $billpayment)
    {
        try{
            if(!globalPermission('payment-bill-by-bill')){
                BillGenerateUpdateJob::dispatch($billpayment->client_id);
            }
        }catch(\Exception $e){

        }

    }
}
