<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddCommissionPercentageToResellerBalanceLog extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('reselle_balance_log_reports', function (Blueprint $table) {
            $table->decimal('reseller_commission_percentage', 8, 2)->default(0.0);
            $table->decimal('pop_commission_percentage', 8, 2)->default(0.0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('reselle_balance_log_reports', function (Blueprint $table) {
            $table->dropColumn('reseller_commission_percentage');
            $table->dropColumn('pop_commission_percentage');
        });
    }
}
