@extends('layout.app')


@section('content')

    <div class="mt-2 card">
        <div class="card-body">
            <div>
                <a href="{{route('adjustment.create')}}" class="btn bg-primary">Add</a>
            </div>
            <div class="table-responsive">
                <table id="dataTable" class="table table-bordered">
                    <thead>
                        <tr>

                            <th class="text-center">
                                 Adjustment Type
                            </th>
                            <th class="text-center">
                                 Date
                            </th>
                            <th class="text-center">
                                Quantity
                            </th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($adjustments as $adjustment)
                        <tr>
                            <td>{{$adjustment->type->name}}</td>
                            <td>{{$adjustment->date}}</td>
                            <td>{{$adjustment->adjustmentItems->sum('quantity')}}</td>
                            <td>
                                <div>
                                    <a href="{{ route('adjustment.edit', $adjustment->id) }}">
                                        <button class="btn btn-success ">Edit</button></a>
                                </div>
                            </td>
                        </tr>

                        @endforeach


                    </tbody>
                </table>
            </div>

            <div class="p-5">
                {{-- {{ $list->links() }} --}}
            </div>
        </div>
    </div>


@endsection
