@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">


            <div class="card card-secondary card-tabs">

                <div class="card-body">
                    <button id="billReminder" class="btn btn-danger btn-block">Send Billing Invoice To All Customer</button>
                </div>

            </div>

        </div>
        <div class="card-body">
            <div class="tab-pane fade show active" id="custom-tabs-one-auto-wellcome-sms" role="tabpanel"
                aria-labelledby="custom-tabs-one-auto-wellcome-sms-tab">
                <div class="container col-md-12">

                    <h2 class="text-center">Send Invoice Using Filter</h2>

                    <form id="form" class="form" action="#">
                        <div class="row">
                            <div class="form-group col-md-3">
                                <label for="reseller_id" class="block text-sm font-medium text-gray-700">
                                    Reseller*
                                </label>
                                <select class="select2 form-control select_option" name="reseller_id" id="reseller">
                                    <option value="">Select One</option>
                                    @foreach (userResellers()->where('reseller_type','own') as $item)
                                        <option value="{{ $item->id }}">{{ $item->name }}</option>
                                    @endforeach
                                </select>
                                @error('reseller_id')
                                    <div class="alert alert-danger mt-1">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <div class="form-group col-md-3">
                                <label> Select POP </label>
                                <select name="pop_id" id="pop" class="select2 form-control select_option">
                                    <option value=""> Select One</option>
                                </select>
                            </div>

                            <div class="form-group col-md-3">
                                <label for="status" class="block text-sm font-medium text-gray-700">
                                    Status
                                </label>
                                <select name="status" id="status" class="select2 form-control" required multiple>
                                    <option value="">Select One</option>
                                    <option value="active">Active</option>
                                    <option value="deactive">Deactive</option>
                                    <option value="expired">Expired</option>
                                    <option value="disable">Disable</option>
                                </select>

                                @error('status')
                                    <div class="alert alert-danger mt-1">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <div class="form-group col-md-3">
                                <label for="status" class="block text-sm font-medium text-gray-700">
                                    Packages
                                </label>
                                <select name="package" id="package" class="select2 form-control" required multiple>
                                    <option value="">Select One</option>
                                    @foreach ($packages as $item)
                                        <option value="{{ $item->id }}">{{ $item->package_name }}</option>
                                    @endforeach
                                </select>

                                @error('status')
                                    <div class="alert alert-danger mt-1">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                        </div>
                        <div class="form-group">
                            <button type="button" id="groupSubmit" class="btn btn-primary float-right">
                                Send
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>


    </div>
@endsection

@section('ajax')
    <script>
        $(function() {

            $('#groupSubmit').click(function(e) {
                e.preventDefault();

                if (confirm("Are you sure to send billing Invoice to this group of customer?")) {

                    $('#processing').show();
                    jQuery.ajaxSetup({
                        async: false
                    });
                    $.get("{{ route('csrf') }}", function(data) {
                        window.token = data;
                    });
                    jQuery.ajaxSetup({
                        async: true
                    });

                    $.ajax({
                        url: "{{ route('billReminderGroup') }}",
                        type: "POST",
                        data: {
                            _token: window.token,
                            reseller_id: $('#reseller').val(),
                            pop_id: $('#pop').val(),
                            status: $('#status').val(),
                            package: $('#package').val(),
                        },
                        success: function(data) {
                            $('#processing').hide();
                            if (data.status == 'success') {
                                toastr.success(data.message);
                            } else {
                                toastr.error(data.message);
                            }
                        },
                        error: function(data) {
                            $('#processing').hide();
                            toastr.error(data.message);
                        }
                    });

                }


            });


            $('#billReminder').click(function() {

                if (confirm("Are you sure to send billing Invoice to all customer?")) {

                    $('#processing').show();

                    jQuery.ajaxSetup({
                        async: false
                    });
                    $.get("{{ route('csrf') }}", function(data) {
                        window.token = data;
                    });
                    jQuery.ajaxSetup({
                        async: true
                    });

                    $.ajax({
                        url: "/admin/billReminder",
                        type: "POST",
                        data: {
                            _token: window.token
                        },
                        success: function(data) {
                            $('#processing').hide();

                            if (data.status == 'success') {
                                toastr.success(data.message);
                            } else {
                                toastr.error(data.message);
                            }
                        }
                    });

                }
            });
        });
    </script>
@endsection
