<?php
namespace App\Classes\SMS;

use App\Jobs\SendSmsJob;
use App\Models\Balance;
use App\Models\Reseller;

class ResellerAccountRechargeSms{

   public function sendSms($reseller_id,$amount,$totalRecharge)
   {
         $reseller = Reseller::find($reseller_id);


        $sms_setting = json_decode(getSmsMessage()->where('tamplate_name', 'reseller_balance_recharge_sms')->first()->tamplate_body,true);
        $sms_send = $sms_setting["sendsms"];
        $message = $sms_setting["sms_body"];
        $contact_customer = $reseller->contact;
        $companyName = siteinfo()->name;
        $companyNumber = siteinfo()->mobile;
        $balance = Balance::where('type','reseller')
                              ->where('type_id',$reseller_id)
                              ->first();

        $message = str_replace(
            [
            '{reseller_name}',
            '{recharge_amount}',
            '{current_balance}',
            '{company_name}',
            '{company_cell}',
            '{total_recharge}',
            ],
            [
                $reseller->name,
                $amount,
                $balance->amount,
                $companyName,
                $companyNumber,
                $totalRecharge
            ],
            $message
        );
        // dd($message);
        if ($sms_send == "Yes") {
            $data = [
                'message' => $message,
                'contact_no' => $contact_customer,
                'type' => 'reseller_account_recharge',
            ];
            SendSmsJob::dispatch($data);
        }

   }

}
