@extends('layout.app')


@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title" style="color:#115548;">Purchase List</h3>
            <div class="card-tools">
                <a href="{{ route('band-purchase.create') }}"><button class="btn btn-sm btn-primary"><i
                            class="fa fa-plus-circle" aria-hidden="true"></i> &nbsp; Purchase</button></a>
            </div>
        </div>

        <div class="card-body">

            <div class="table-responsive">
                <table id="dataTable" class="display table table-bordered table-striped">
                    <thead class="bg-gray-50">
                        <tr>
                            <th> SL </th>
                            <th> Invoice </th>
                            <th> Document </th>
                            <th> Provider </th>
                            <th> Billing Date </th>
                            <th> Total </th>
                            <th> Paid </th>
                            <th> Due </th>
                            <th style="width: 100px; "> Action </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @php
                            $total = 0;
                            $paid = 0;
                            $due = 0;
                        @endphp
                        @foreach ($list as $item)
                            <tr>
                                <td>{{ $item->id }}</td>
                                <td>{{ $item->invoice_no }}</td>
                                <td>
                                    @php
                                        $isS3 = checkSettings('store_image_to_s3') === 'enable';
                                        $imgUrl = $isS3
                                            ? $item->document // assume full URL from S3
                                            : (!empty($item->document) ? asset('storage/bandPurchase/' . $item->document) : null);
                                    @endphp
                                    @if ($imgUrl)
                                        <img src="{{ $imgUrl }}" alt="No Image" class="img-fluid"
                                            style="max-width: 100%; height: 100px;" />
                                    @else
                                        <h6 class="lead">Image Not Provided</h6>
                                    @endif

                                </td>
                                <td>{{ $item->provider->company_name ?? '' }}</td>
                                <td>{{ $item->billing_date }}</td>
                                <td style="text-align: right">{{ $item->total_price }}</td>
                                <td style="text-align: right">{{ $item->paid }}</td>
                                <td style="text-align: right">
                                    @php
                                        $d_amount = $item->total_price - $item->paid;
                                    @endphp
                                    {{ number_format($d_amount, 2) }}
                                </td>
                                <td>
                                    <div class="row">
                                        <div class="ml-1">
                                            <a href="{{ route('band-purchase.edit', $item->id) }}"
                                                class="form-control btn btn-warning">Edit</a>
                                        </div>
                                    </div>
                                </td>
                                @php
                                    $total += $item->total_price;
                                    $paid += $item->paid;
                                    $due += $item->total_price - $item->paid;
                                @endphp
                            </tr>
                        @endforeach
                        <tr>
                            <td colspan="5" style="text-align: right"><b>Total</b></td>
                            <td style="text-align: right"><b>{{ number_format($total, 2) }}</b></td>
                            <td style="text-align: right"><b>{{ number_format($paid, 2) }}</b></td>
                            <td style="text-align: right"><b>{{ number_format($due, 2) }}</b></td>
                            <td></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="modal fade" id="make-payment">
        <div class="modal-dialog">
            <form action="{{ route('makePayment', 'purchaseId') }}" method="POST" class="recharge-form">
                @csrf
                @method('post')
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="text-center">Purchase Payment</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="text-center" id="modalAlert"></div>

                        <input type="hidden" name="purchaseId" id="purchaseId" value="" />

                        <div class="row">
                            <div class="col-md-4">Subtotal Amount</div>
                            <div class="col-md-8 mb-2">
                                <input type="number" class="form-control" name="subTotal" id="subTotal" value=""
                                    readonly step="0.001">
                            </div>
                            <div class="col-md-4">Paid Amount</div>
                            <div class="col-md-8 mb-2">
                                <input type="text" class="form-control" name="paid" id="paid" value=""
                                    min="0" readonly step="0.001">
                            </div>
                            <div class="col-md-4">Due Amount</div>
                            <div class="col-md-8 mb-2">
                                <input type="number" class="form-control" name="due" id="due" value=""
                                    readonly step="0.001">
                            </div>
                            <div class="col-md-4">Pay Now</div>
                            <div class="col-md-8 mb-2">
                                <input type="number" class="form-control" name="newPaid" id="newPaid" value=""
                                    required min="0" step="0.001">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button class="btn btn-primary recharge-submit" type="submit" id="modalSave">Save</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('ajax')
    <script>
        $('#newPaid').keyup(function() {
            calculation();
        });

        function calculation() {
            const subTotal = $('#subTotal').val();
            const paid = $('#paid').val();
            const due = $('#due').val();
            const newPaid = $('#newPaid').val();

            const total = parseFloat(subTotal) - parseFloat(paid) - parseFloat(newPaid);
            $('#due').val(total.toFixed(2));
        }

        $(document).on("click", ".open-payment", function() {
            var purchaseId = $(this).data('id');
            $(".modal-body #purchaseId").val(purchaseId);
            var subtotal = $(this).data('subtotal');
            $(".modal-body #subTotal").val(subtotal);
            var paid = $(this).data('paid');
            $(".modal-body #paid").val(paid);
            var due = $(this).data('due');
            $(".modal-body #due").val(due);
        });
    </script>
@endsection
