@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">
            <form action="" id="search" class="form">

                <div class="col-md-6 mb-2">
                    <label class="flex-1 block text-gray-700 text-sm font-bold mb-2">
                        Search By
                    </label>
                    <div class="row">
                        <div class="col-md-6">
                            <select name="type" class="form-control form-control-sm" id="type" required>
                                <option value="userid" selected>User Name</option>
                                <option value="contact_no">Contact No</option>
                                <option value="id">ID</option>
                                <option value="batch">Batch</option>
                            </select>
                        </div>
                        <div class="col-md-6 ">
                            <input class="form-control inputbox form-control-sm" name="value" type="text"
                                placeholder="" required>
                        </div>
                    </div>
                </div>

                <div class="row" id="batchSection" style="display: none">
                    <div class="col-md-2 col-sm-3 col-xs-6">
                        <div class="form-group">
                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                Manager Name*
                            </label>
                            <select name="reseller" id="reseller" class="form-control select2 form-control-sm" required>
                                <option value="">Select Manager</option>
                                @foreach (userResellers() as $r)
                                    <option value="{{ $r->id }}">{{ $r->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2 col-sm-3 col-xs-6">
                        <div class="form-group">
                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                POP Name*
                            </label>
                            <select name="pop" id="pop" class="form-control select2 form-control-sm" required>
                                <option value=""> Select POP</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-2 col-sm-3 col-xs-6">
                        <div class="form-group">
                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="area">
                                Area Name
                            </label>
                            <select name="area" id="area" class="form-control select2 form-control-sm" required>
                                <option value="all"> ALL Area</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2 col-sm-3 col-xs-6">
                        <div class="form-group">
                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                Billing Cycle
                            </label>
                            <select name="billing_cycle" id="billing_cycle" class="select2 form-control form-control-sm">
                                <option value="">Select One</option>
                                @foreach (explode(',', $confday) as $conf)
                                    <option value="{{ $conf }}">{{ $conf }}</option>
                                @endforeach
                                {{-- @for ($i = 1; $i <= 31; $i++)
                            <option value="{{$i}}">{{$i}}</option>
                        @endfor --}}
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2 col-sm-3 col-xs-6">
                        <div class="form-group">
                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                User Status
                            </label>
                            <select name="user_state" class="form-control form-control-sm">
                                <option value="">Customer Status</option>
                                <option value="active">Active</option>
                                <option value="disable">Disable</option>
                                <option value="deactive">Deactive</option>
                                <option value="expired">Expired</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2 col-sm-3 col-xs-6">
                        <div class="form-group">
                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="pack_or_sub_pack">
                                Package/Sub Package
                            </label>
                            <select name="pack_or_sub_pack" class="form-control form-control-sm" id="pack_or_sub_pack">
                                <option value="">Select One</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-2 col-sm-3 col-xs-6">
                        <div class="form-group">
                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">Expire
                                Date</label>
                            <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                <input type="text" name="expire_date"
                                    class="form-control form-control-sm datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchFrom" autocomplete="off">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-group float-right mt-2">
                    <input type="hidden" name="changeType" value="packageChange">
                    <button @click="search" class="btn btn-primary" type="submit" id="searchBtn"><i
                            class="fa fa-search"></i> Search</button>
                    <button class="btn btn-info" type="reset" id="reset">Reset</button>
                </div>
            </form>

            <div id="result">
                {{-- list will show in this box --}}
            </div>




        </div>
    </div>

    {{-- <x-Custom.modal modalTitle="Reseller Recharge">
    <x-Custom.inputGroup inputName="amount" labelName="Amount" labelIcon="" placeholder="0" inputType="number" required="required"/>
    <x-Custom.formUpdateBtn value="Recharge" class="float-right bg-blue-300 mt-2"/>
  </x-Custom.modal> --}}
@endsection




@section('ajax')
    <script type="text/javascript">
        $(function() {
            $('#reset').click(function() {
                $('#result').html('');
                $('.select2').val('').trigger('change');
            });
            $('#searchBtn').on('click', function(e) {
                e.preventDefault();
                $('body').prepend('<div id="loading">Loading.....</div>');
                $.ajax({
                    type: 'get',
                    url: '{{ route('getClientDetails') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('#result').html(result);
                        $('#loading').remove();
                    }
                });
            });

            $('#type').on('change', function() {

                let type_val = $('#type').val();

                if (type_val == 'batch') {
                    $('.inputbox').hide();
                    $('#batchSection').show();
                } else {
                    $('.inputbox').show();
                    $('#batchSection').hide();
                }
            });

            $('#pop').on('change', function(e) {
                // console.log('this is me');
                e.preventDefault();
                $('#processing').show();

                $.ajax({
                    type: 'get',
                    url: '{{ route('getPopWisePackList') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#pack_or_sub_pack').html(result);
                        $('#processing').hide();
                    }
                });
            });

            $('#pop').on('change', function(e) {
                e.preventDefault();
                $('body').append('<div class="hidden" id="loading">Loading.....</div>');

                $.ajax({
                    type: 'get',
                    url: '{{ route('getPopWiseAreaList') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#area').html(result);
                        $('#loading').remove();
                    }
                });
            });

        });
    </script>
@endsection
