<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>QR Code Payment</title>

    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: white;
            margin: 0;
            padding: 20px;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }

        .container {
            width: 100%;
            max-width: 10cm;
            height: 13cm;
            position: relative;
            background: white;
            border-radius: 10px;
            text-align: center;
            padding: 15px 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            color: #333;
            overflow: hidden;
            page-break-inside: avoid;
            margin: 0 auto;
            border: 1px solid #f1c40f;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }

        .logo-circle {
            width: 60px;
            height: 60px;
            background-color: white;
            border-radius: 50%;
            margin: 0 auto 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            flex-shrink: 0;
        }

        .logo-circle img {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            object-fit: cover;
        }

        .network-title {
            font-size: 16px;
            font-weight: bold;
            color: #333;
            margin: 8px 0 12px 0;
            text-shadow: none;
            flex-shrink: 0;
        }

        .client-info {
            text-align: left;
            margin: 10px 0;
            background: linear-gradient(to bottom, #004aad, #cb6ce6);
            padding: 8px;
            border-radius: 8px;
            border: 1px solid #eee;
            flex-shrink: 0;
        }

        .client-info p {
            margin: 3px 0;
            font-size: 11px;
            color: #ffffff;
            font-weight: 500;
        }

        .scan-text {
            font-size: 12px;
            font-weight: bold;
            color: #333;
            margin: 8px 0 6px 0;
            text-shadow: none;
            flex-shrink: 0;
        }

        .qr-code-container {
            width: 120px;
            height: 120px;
            background-color: white;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 8px auto;
            padding: 5px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            flex: 1;
            min-height: 120px;
        }

        .qr-code svg {
            width: 110px;
            height: 110px;
        }

        .thank-you {
            font-size: 14px;
            color: #ffffff;
            margin: 8px 0;
            font-weight: bold;
            background: linear-gradient(to top, #004aad, #cb6ce6);
            padding: 6px;
            border-radius: 8px;
            border: 1px solid #eee;
            text-shadow: none;
            flex-shrink: 0;
        }

        .contact-info {
            margin-top: 6px;
            font-size: 9px;
            color: #333;
            line-height: 1.2;
            text-align: left;
            flex-shrink: 0;
        }

        .footer {
            font-size: 9px;
            color: #666;
            margin-top: 6px;
            opacity: 0.9;
            flex-shrink: 0;
        }

        .print-controls {
            position: fixed;
            top: 20px;
            right: 20px;
            background: white;
            padding: 15px;
            border: 1px solid #ddd;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            z-index: 1000;
        }

        .printbtn {
            background-color: #0bc8d6;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s;
            margin-right: 10px;
        }

        .back-btn {
            background-color: #6c757d;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
        }

        .back-btn:hover {
            background-color: #5a6268;
        }

        /* Print Styles */
        @media print {
            body {
                -webkit-print-color-adjust: exact;
                margin: 0;
                padding: 5mm;
            }

            .print-controls {
                display: none;
            }

            .container {
                width: 100%;
                max-width: 10cm;
                height: 13cm;
                border-radius: 8px;
                text-align: center;
                padding: 10px 8px;
                color: #333;
                box-shadow: none;
                border: 1px solid #ccc;
            }

            .qr-code-container {
                padding: 3px;
            }
        }
    </style>

</head>

<body>
    <div class="print-controls">
        <button class="printbtn" onclick="window.print()">Print</button>
    </div>

    <div class="container">
        <!-- Circular Logo -->
        <div class="logo-circle">
            <img src="{{ asset('storage/company/' . siteinfo()->img_url) }}" alt="Logo">
        </div>

        <!-- Network Title -->
        <div class="network-title">{{ siteinfo()->name ?? 'Company Name' }}</div>

        <!-- Client Information -->
        <div class="client-info">
            <p>Username: {{ $client->userid }}</p>
            <p>CID: {{ $client->id ?? '' }}</p>
            <p>Name: {{ $client->clientsinfo->clients_name ?? '' }}</p>
            <p>Number: {{ $client->clientsinfo->contact_no ?? '' }}</p>
            @if($client->customer_code)
                <p>Customer Code: {{ $client->customer_code ?? '' }}</p>
            @endif
        </div>

        <!-- Scan Text -->
        <div class="scan-text">QR কোড স্ক্যান করে পেমেন্ট করুন</div>

        <!-- QR Code -->
        <div class="qr-code-container">
            <div class="qr-code">{!! $qrCode !!}</div>
        </div>

        <!-- Thank You -->
        <div class="thank-you">ধন্যবাদ</div>

        <!-- Contact Information -->
        <div class="contact-info">
            <div>Address: {!! siteinfo()->address ?? '' !!}</div>
            <div>Contact: {{ siteinfo()->mobile ?? '' }}</div>
        </div>

        <!-- Footer -->
        <div class="footer">Powered by YetFix Limited</div>
    </div>
</body>

</html>
