@can('mikrotik_index')
    <li class="nav-item {{ request()->routeIs(['mikrotik*']) ? 'menu-open' : '' }}">
        <a href="#" class="nav-link">
            <i class="fas fa-server nav-icon"></i>
            <p>
                Mikrotik
                <i class="fas fa-angle-left right"></i>
            </p>
        </a>
        <ul class="nav nav-treeview">

            @can('mikrotik_create')
                {{-- <li class="nav-item">
                    <a href="{{ route('mikrotiks.create') }}"
                        class="nav-link {{ request()->routeIs(['mikrotiks.create']) ? 'active' : '' }}">
                        <i class="ml-3 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Add Mikrotik</p>
                    </a>

                </li> --}}
            @endcan

            @can('mikrotik_index')
                <li class="nav-item">
                    <a href="{{ route('mikrotiks.index') }}"
                        class="nav-link {{ request()->routeIs(['mikrotiks.index']) ? 'active' : '' }}">
                        <i class="ml-3 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Mikrotiks</p>
                    </a>
                </li>
            @endcan

            @if (checkSettings('customer-sync') == 'enable')
                <li class="nav-item">
                    <a href="{{ route('mikrotiks-sync') }}"
                        class="nav-link {{ request()->routeIs(['mikrotiks-sync']) ? 'active' : '' }}">
                        <i class="ml-3 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Sync </p>
                    </a>

                </li>
                {{-- <li class="nav-item">
                    <a href="{{ route('sync-client-list') }}"
                        class="nav-link {{ request()->routeIs(['sync-client-list']) ? 'active' : '' }}"><i
                            class="ml-3 far fa-circle nav-icon" style="font-size: 10px"></i>
                        <p>Sync Client List</p>
                    </a>

                </li> --}}

            @endif

        </ul>
    </li>
@endcan

@canany(['reseller_index', 'specific_management_services'])
    <li class="nav-item {{ request()->routeIs(['resellers*', 'resellers-sms-log']) ? 'menu-open' : '' }}">
        <a href="#" class="nav-link">
            <i class="fas fa-user-tie nav-icon"></i>
            <p>
                Manager
                <i class="fas fa-angle-left right"></i>
            </p>
        </a>
        <ul class="nav nav-treeview">

            <li class="nav-item">
                @can('reseller_create')
                    <a href="{{ route('resellers.create') }}"
                        class="nav-link {{ request()->routeIs(['resellers.create']) ? 'active' : '' }}">
                        <i class="ml-3 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Add Manager</p>
                    </a>
                @endcan
            </li>

            <li class="nav-item">
                @canany(['reseller_index', 'specific_management_services'])
                    <a href="{{ route('resellers.index') }}"
                        class="nav-link {{ request()->routeIs(['resellers.index']) ? 'active' : '' }}">
                        <i class="ml-3 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Managers</p>
                    </a>
                @endcan
            </li>
            @if (checkSettings('manager_status') == 'enable')
                <li class="nav-item">
                    <a href="{{ route('activeManager') }}"
                        class="nav-link {{ request()->routeIs(['activeManager']) ? 'active' : '' }}">
                        <i class="ml-3 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Active Managers</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('inactiveManager') }}"
                        class="nav-link {{ request()->routeIs(['inactiveManager']) ? 'active' : '' }}">
                        <i class="ml-3 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Inactive Managers</p>
                    </a>
                </li>
            @endif

            @cannot('specific_management_services')
                <li class="nav-item">

                    <a href="{{ route('resellers-sms-log') }}"
                        class="nav-link {{ request()->routeIs(['resellers-sms-log']) ? 'active' : '' }}">
                        <i class="ml-3 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Manager Sms Log</p>
                    </a>

                </li>
            @endcannot

        </ul>

    </li>
@endcan

@canany(['pop_index', 'specific_management_services'])
    <li class="nav-item {{ request()->routeIs(['pop*', 'reseller-area*', 'box*', 'activeInactivePopList']) ? 'menu-open' : '' }}">
        <a href="#" class="nav-link">
            <i class="fas fa-map-marked-alt nav-icon"></i>
            <p>
                POP
                <i class="fas fa-angle-left right"></i>
            </p>
        </a>
        <ul class="nav nav-treeview">
            @can('reseller_area_index')
                <li class="nav-item {{ request()->routeIs(['reseller-area*']) ? 'menu-open' : '' }}">
                    <a href="#" class="nav-link">
                        <i class="ml-3 nav-icon fas fa-copy"></i>
                        <p>
                            Area
                            <i class="fas fa-angle-left right"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        @can('reseller_area_index')
                            <li class="nav-item">
                                <a href="{{ route('reseller-area.index') }}"
                                    class="nav-link {{ request()->routeIs(['reseller-area.index']) ? 'active' : '' }}">
                                    <i class="ml-4 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                                    <p>Areas</p>
                                </a>
                            </li>
                        @endcan
                        @can('reseller_area_create')
                            <li class="nav-item">
                                <a href="{{ route('reseller-area.create') }}"
                                    class="nav-link {{ request()->routeIs(['reseller-area.create']) ? 'active' : '' }}">
                                    <i class="ml-4 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                                    <p>Add Area</p>
                                </a>
                            </li>
                        @endcan
                    </ul>
                </li>
            @endcan


            <li class="nav-item">
                @can('pop_create')
                    <a href="{{ route('pop.create') }}"
                        class="nav-link {{ request()->routeIs(['pop.create']) ? 'active' : '' }}">
                        <i class="ml-4 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Add POP / Zone</p>
                    </a>
                @endcan
            </li>

            @if (checkSettings('box') == 'enable')
                <li class="nav-item {{ request()->routeIs(['box*']) ? 'menu-open' : '' }}">
                    <a href="#" class="nav-link">
                        <i class="ml-3 nav-icon fas fa-copy"></i>
                        <p>
                            Box
                            <i class="fas fa-angle-left right"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="{{ route('box.index') }}"
                                class="nav-link {{ request()->routeIs(['box.index']) ? 'active' : '' }}">
                                <i class="ml-4 far fa-circle nav-icon" style="font-size: 10px"></i>
                                <p>Box</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('box.create') }}"
                                class="nav-link {{ request()->routeIs(['box.create']) ? 'active' : '' }}"><i
                                    class="ml-4 far fa-circle nav-icon" style="font-size: 10px"></i>
                                <p>Add Box</p>
                            </a>
                        </li>
                    </ul>
                </li>
            @endif

            <li class="nav-item">
                @can('pop_exception')
                    <a href="{{ route('pop.exception') }}"
                        class="nav-link {{ request()->routeIs(['pop.exception']) ? 'active' : '' }}">
                        <i class="ml-4 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Expiry Exception</p>
                    </a>
                @endcan
            </li>


            <li class="nav-item">
                @canany(['pop_index', 'specific_management_services'])
                    <a href="{{ route('pop.index') }}"
                        class="nav-link {{ request()->routeIs(['pop.index']) ? 'active' : '' }}">
                        <i class="ml-4 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Pops / Zones</p>
                    </a>
                @endcan
            </li>


            @can('up-down-report-package-wise')
                @if(!checkAPI())

                    <li class="nav-item">
                        <a href="{{ route('package-upload-download') }}"
                            class="nav-link {{ request()->routeIs(['package-upload-download']) ? 'active' : '' }}">
                            <i class="ml-4 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                            <p>Packages ⬆️⬇️ Report</p>
                        </a>
                    </li>
                @endif
            @endcan
            @if (checkSettings('active_inactive_pop') == 'enable')
                @can('active-inactive-pop')
                    <li class="nav-item">
                        <a href="{{ route('activeInactivePopList') }}"
                            class="nav-link {{ request()->routeIs(['activeInactivePopList']) ? 'active' : '' }}">
                            <i class="ml-4 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                            <p>Inactive POP List</p>
                        </a>
                    </li>
                @endcan

            @endif
        </ul>
    </li>
@endcan

@canany(['package_index', 'sub-package_index', 'specific_management_services','package-upload-download'])
    <li class="nav-item {{ request()->routeIs(['packages*', 'sub-package*', 'sync-profile-list']) ? 'menu-open' : '' }}">
        <a href="#" class="nav-link">
            <i class="fas fa-list-alt nav-icon"></i>
            <p>
                Package
                <i class="fas fa-angle-left right"></i>
            </p>
        </a>
        <ul class="nav nav-treeview">

            @can('package_create')
                <li class="nav-item">
                    <a href="{{ route('sync-profile-list') }}"
                        class="nav-link {{ request()->routeIs(['sync-profile-list']) ? 'active' : '' }}">
                        <i class="ml-4 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Sync Profile List</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('packages.create') }}"
                        class="nav-link {{ request()->routeIs(['packages.create']) ? 'active' : '' }}">
                        <i class="ml-4 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Add Package</p>
                    </a>

                </li>
            @endcan

            @can('sub-package_create')
                <li class="nav-item">
                    <a href="{{ route('sub-packages.create') }}"
                        class="nav-link {{ request()->routeIs(['sub-packages.create']) ? 'active' : '' }}">
                        <i class="ml-4 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Add Sub Package</p>
                    </a>
                </li>
            @endcan

            @canany(['package_index', 'specific_management_services'])
                <li class="nav-item">
                    <a href="{{ route('packages.index') }}"
                        class="nav-link {{ request()->routeIs(['packages.index']) ? 'active' : '' }}">
                        <i class="ml-4 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Packages</p>
                    </a>
                </li>
            @endcan
            @if (checkSettings('radius_customer_bandwidth_limit') == 'enable')


            @endif
            @canany(['sub-package_index', 'specific_management_services'])
                <li class="nav-item">
                    <a href="{{ route('sub-packages.index') }}"
                        class="nav-link {{ request()->routeIs(['sub-packages.index']) ? 'active' : '' }}">
                        <i class="ml-4 fa fa-circle nav-icon" style="font-size: 6px !important"></i>
                        <p>Sub Packages</p>
                    </a>
                </li>
            @endcan



        </ul>
    </li>

@endcan
