@extends('layout.app')


@section('content')


    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-md-6 form-group">
                    <label for="userid">User Id</label>
                    <input class="form-control" id="search_input" type="text">
                </div>
            </div>
            <div class="form-group float-left">

                <button class="btn btn-warning" id="add">Add</button>
            </div>
            <div class="form-group float-right">
                <button class="btn btn-primary" id="search_btn">Search</button>
            </div>

            <div class="" id="result">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Id</th>
                            <th>User name</th>
                            <th>Attribute</th>
                            <th>OP</th>
                            <th>Value</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                </table>
            </div>


        </div>


    </div>






@endsection
@section('ajax')
<script>
    $(function() {
        $('#search_btn').on('click', function() {
            var userid = $('#search_input').val();
            if(userid){
                $('body').prepend('<div id="loading">Loading.....</div>');

                $.ajax({
                    url: '{{ route('search-in-redcheck') }}',
                    type: "GET",
                    data: {
                        userid: userid
                    },
                    success: function(data) {
                        $('#result').html(data);
                        $('#loading').remove();
                    }
                });
            }
        });

        $('#search_input').on('keyup',function(e){
            if(e.keyCode == 13)
            {
                $('#search_btn').click();
            }
        });

        $('#add').on('click',function(e){
            let userid = $('#search_input').val();
            if(userid){
                $('body').prepend('<div id="loading">Loading.....</div>');
                $.ajax({
                    url: '{{ route('addredcheck') }}',
                    type: "POST",
                    data: {
                        userid: userid
                    },
                    success: function(data) {

                        $('#result').html(data);
                        $('#loading').remove();
                        if(data.message){
                            toastr.error(data.message);
                            if(data.message == 'User Already Exist In Redcheck and RedUserGroup Table'){
                                $('#search_btn').click();
                            }
                        }else{

                            toastr.success('User added successfully');
                        }
                    }
                });
            }

        });
    });
</script>
@endsection
