@extends('layout.app')


@section('content')
    <div class="card">

        <div class="card-body">
            <form action="{{ route('passwordReset', $r->email) }}" method="POST">
                @method('put')
                @csrf
                <input type="hidden" name="email" value="{{ $r->email }}">
                <div class="form-group">
                    <label class="" for="password">
                        Password
                    </label>
                    <input class="form-control" name="password" id="password" type="password" required>
                    @error('password')
                        <div class="text-red-500 mt-2 text-sm">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group">
                    <label class="">
                        Confirm Password
                    </label>
                    <input class=" form-control" name="password_confirmation" id="password_confirmation" type="password"
                        required>
                    @error('password_confirmation')
                        <div class="text-red-500 mt-2 text-sm">{{ $message }}</div>
                    @enderror
                </div>
                <div class="form-group">
                    <a href="{{ route('user.index') }}" class="btn btn-default"><i class="fa fa-arrow-left"></i> Back</a>

                    <button type="submit" class="btn btn-primary float-right">
                        Password Update
                    </button>
                </div>

            </form>
        </div>
    </div>
@endsection
