<?php

use App\Http\Controllers\CustomerSummaryController;
use App\Http\Controllers\FixCommonIssueController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\SchedulePackageChangeController;

use Illuminate\Support\Facades\Route;

Route::group(['middleware' => ['can:due-amount-check-by-month']], function () {
    Route::get('due-amount-check-by-month', [ReportController::class, 'dueAmountCheckByMonth'])->name('due-amount-check-by-month');
});
    Route::get('dueAmountCheckByMonthSearch', [ReportController::class, 'dueAmountCheckByMonthSearch'])->name('dueAmountCheckByMonthSearch');
    Route::get('duplicate-money-receipt', [ReportController::class, 'duplicateMoneyReceipt'])->name('duplicate-money-receipt');
    Route::get('permanent-discount-list', [ReportController::class, 'permanentDiscountList'])->name('permanent-discount-list');
    Route::get('schedule-package-change-list', [SchedulePackageChangeController::class, 'schedulePackageChangeList'])->name('schedule-package-change-list');
    Route::get('all-customer-summary', [CustomerSummaryController::class, 'allCustomerSummary'])->name('all-customer-summary');
    Route::get('make-all-permanent-discount-null-zero', [FixCommonIssueController::class, 'setAllPermanentDiscountNullValueToZero'])->name('make-all-permanent-discount-null-zero');
    Route::group(['middleware' => ['can:running-due']], function () {
        Route::get('runningMonthDue', [ReportController::class, 'runningMonthDue'])->name('runningMonthDue');
    });
    Route::group(['middleware' => ['can:marketing-new-customer-report']], function () {
        Route::get('marketing-new-customer-report', [ReportController::class, 'marketingNewCustomerReport'])->name('marketing-new-customer-report');
        Route::get('kam-report-search', [ReportController::class, 'kameReportSearch'])->name('kam-report-search');
        Route::get('kam-report-detail/{user_id}', [ReportController::class, 'kamReportDetail'])->name('kam-report-detail');
    });




