<?php

namespace App\Classes;

use Illuminate\Support\Facades\Http;

class Notification
{
  public function notify($message, $type = 'all')
  {
    if (checkSettings('telegram-notify') == 'enable') {
      $this->telegram($message, $type);
    }
  }

  public function supportNotify($message)
  {
    if (checkSettings('telegram-notify') == 'enable') {
      $telegram = json_decode(siteinfo()->telegram_for_support);

      
      // $chat_id = '@billingfixxyz';
      // $api = '5569782331:AAEptw5_2YJEvCXvXfJwvozv4b0IYClB5IM';

      $chat_id = $telegram[0]->chat_id;
      $api = $telegram[0]->api;
      $url = "https://api.telegram.org/bot" . $api . "/sendMessage?chat_id=" . $chat_id . "&text=" . $message;
      $response = Http::get($url);
    }
  }


  public function telegram($message, $type)
  {
    $telegram = json_decode(siteinfo()->telegram);    

    // $chat_id = '@billingfixxyz';
    // $api = '5569782331:AAEptw5_2YJEvCXvXfJwvozv4b0IYClB5IM';

    $chat_id = $telegram[0]->chat_id;
    $api = $telegram[0]->api;
    $url = "https://api.telegram.org/bot" . $api . "/sendMessage?chat_id=" . $chat_id . "&text=" . $message;
    $response = Http::get($url);
  }
}
