@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">
            <form action="" id="search" class="resellerRechargeLog">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Select Reseller</label>
                            <select name="reseller" id="reseller" class="select2 form-control form-control-sm">
                                <option value="">Select One</option>
                                @foreach ($reseller as $r)
                                    <option value="{{ $r->id }}">{{ $r->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <label class='block uppercase tracking-wide text-gray-700 text-xs font-bold mb-2'>Select
                            POP
                        </label>
                        <select name="pop" id="pop" class="form-control select2 form-control-sm">
                            <option value="all"> Select One</option>
                        </select>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group float-right">
                            <button @click="search" class="btn btn-primary" type="submit" id="searchBtn"><i
                                    class="fa fa-search"></i> Search</button>
                            <button class="btn btn-info" type="reset" id="reset">Reset</button>
                        </div>
                    </div>
                </div>

                {{-- <div id="result">

                </div> --}}

            </form>


        </div>
    </div>


    <div class="mt-2 card">
        <div class="card-body">
            {{-- @if (isset($print_url) && !empty($print_url))
                <a href="{{ route($print_url) }}" target="_blank"><i class="fa fa-print"></i></a>
            @endif

            <input type="text" id="customer_search" name="customer_search" class="float-right">

            <br>

            <div id="processing">
                <div>Processing.....</div>
            </div> --}}



            <div id="customer_list_body">
                <div id="processing">
                    <div>Processing.....</div>
                </div>
                <div class="table-responsive" id="result">
                    @include('clients.search.list-result')

                </div>
            </div>
        </div>
        <div class="card-footer">
        </div>
    </div>

    <style>
        div#processing {
            display: none;
        }

        div#processing div {
            background: rgba(0, 0, 0, .5);
            position: fixed;
            width: 100vw;
            height: 100vh;
            color: #fff;
            text-align: center;
            vertical-align: middle;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        @media print {
            a {
                text-decoration: none !important;
                color: #222 !important;
            }

            th {
                font-size: 10px !important;
                padding: 2px !important;
                text-align: center;
            }

            tr {
                font-size: 10px !important;
                margin: 2px !important;
                padding: 2px !important;
            }

            td {
                font-size: 10px !important;
                margin: 2px !important;
                padding: 2px !important;
            }

            table {
                width: 100%;
            }

            .shadow {
                box-shadow: none;
            }

            tr th:last-child {
                display: none !important;
            }

            tr td:last-child {
                display: none !important;
            }

        }
    </style>
@endsection

@section('ajax')
    <script type="text/javascript">
        $(function() {

            $('#result table').DataTable({
                processing: true
            });

            $('#reset').click(function() {
                $('#result').html('');
                $('#pop').html('<option value="all">Select One</option>');
            });



            $('#searchBtn').on('click', function(e) {
                e.preventDefault();
                $('#processing').show();
                $.ajax({
                    type: 'get',
                    url: '{{ route('expiredCustomerSearch') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('#result').html(result);
                        $('#result table').DataTable({
                            'destroy': true,
                        });
                        $('#processing').hide();
                    }
                });
            });


            $('#reseller').on('change', function(e) {
                e.preventDefault();
                $('#processing').show();

                $.ajax({
                    type: 'get',
                    url: '{{ route('getResellerPopList') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#pop').html(result);
                        $('#processing').hide();

                    }
                });
            });

        });
    </script>
@endsection
