<?php

namespace App\Imports;

use DateTime;
use Exception;
use Throwable;
use Carbon\Carbon;
use App\Models\Nas;
use App\Models\Pop;
use App\Models\Client;
use App\Models\Packages;
use App\Models\SubPackage;
use App\Models\Clientsinfo;
use GuzzleHttp\Promise\Create;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use App\Models\MikcrotikClientList;
use App\Models\ReselleBalanceLogReport;
use Maatwebsite\Excel\Concerns\Importable;
use App\Models\SubResellerBalanceLogReport;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Facade\Ignition\Support\Packagist\Package;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class ClientsImport implements ToCollection
{
    use Importable;
    public function collection(Collection $rows)
    {
        // For Static IP

        $count = 0;
        foreach ($rows as $row) {
            $count++;
            $pop = Pop::where('popname', $row[1])->first();
            if ($pop == null) {
                dd("pop", $row[1], $count);
            }

            $check_client = Client::where('userid', trim($row[0]))->first();

            if ($check_client != null) {
                $check_client->pop_id = $pop->id;
                $check_client->save();

                $clientInfo = Clientsinfo::where('client_id', $check_client->id)->first();
                $clientInfo->road_no = $row[2];
                $clientInfo->save();
            }
        }
    }
}
