<?php

namespace App\Http\Controllers\Customer;

use Carbon\Carbon;
use App\Models\Client;
use App\Models\BkashPayment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Session;
use App\Http\Controllers\PaymentController;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\Log;

class BkashCheckoutController extends Controller
{

        private $base_url;
        private $app_key;
        private $app_secret;
        private $username;
        private $password;

        public function __construct()
        {
            // bKash Merchant API Information

            // You can import it from your Database
            $bkash_app_key = '5tunt4masn6pv2hnvte1sb5n3j'; // bKash Merchant API APP KEY
            $bkash_app_secret = '1vggbqd4hqk9g96o9rrrp2jftvek578v7d2bnerim12a87dbrrka'; // bKash Merchant API APP SECRET
            $bkash_username = 'sandboxTestUser'; // bKash Merchant API USERNAME
            $bkash_password = 'hWD@8vtzw0'; // bKash Merchant API PASSWORD
            $bkash_base_url = 'https://checkout.sandbox.bka.sh/v1.2.0-beta'; // For Live Production URL: https://checkout.pay.bka.sh/v1.2.0-beta

            $this->app_key          = config('app.bkash_app_key');
            $this->app_secret       = config('app.bkash_app_secret');
            $this->username         = config('app.bkash_username');
            $this->password         = config('app.bkash_password');
            $this->base_url         = config('app.bksh_base_url');
            $this->payerReference   = config('app.bkash_payerReference');
            $this->callbackurl      = config('app.bkash_callbackurl');

            for($i=2001;$i<=2069;$i++){
                $this->error[] = $i;
            }
        }

        public function getToken()
        {
            session()->forget('bkash_token');

            $post_token = array(
                'app_key' => $this->app_key,
                'app_secret' => $this->app_secret
            );

            $url = curl_init("$this->base_url/checkout/token/grant");
            $post_token = json_encode($post_token);
            $header = array(
                'Accept:application/json',
                'Content-Type:application/json',
                "password:$this->password",
                "username:$this->username"
            );

            curl_setopt($url, CURLOPT_HTTPHEADER, $header);
            curl_setopt($url, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($url, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($url, CURLOPT_POSTFIELDS, $post_token);
            curl_setopt($url, CURLOPT_FOLLOWLOCATION, 1);
            $resultdata = curl_exec($url);
            curl_close($url);

            $response = json_decode($resultdata, true);


            if (array_key_exists('msg', $response)) {
                return $response;
            }

            session()->put('bkash_token', $response['id_token']);

            return response()->json(['success', true]);
        }

        public function createPayment(Request $request)
        {

            // if (((string) $request->amount != (string) session()->get('bkash')['invoice_amount'])) {
            //     return response()->json([
            //         'errorMessage' => 'Amount Mismatch',
            //         'errorCode' => 2006
            //     ],422);
            // }

            $token = session()->get('bkash_token');

            $request['intent'] = 'sale';
            $request['currency'] = 'BDT';
            $request['merchantInvoiceNumber'] = rand();

            $url = curl_init("$this->base_url/checkout/payment/create");
            $request_data_json = json_encode($request->all());
            $header = array(
                'Content-Type:application/json',
                "authorization: $token",
                "x-app-key: $this->app_key"
            );

            curl_setopt($url, CURLOPT_HTTPHEADER, $header);
            curl_setopt($url, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($url, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($url, CURLOPT_POSTFIELDS, $request_data_json);
            curl_setopt($url, CURLOPT_FOLLOWLOCATION, 1);
            curl_setopt($url, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
            $resultdata = curl_exec($url);

            $this->_storeCreatePayment($resultdata);

            curl_close($url);
            return json_decode($resultdata, true);
        }



        public function executePayment(Request $request)
        {

            $token = session()->get('bkash_token');

            $paymentID = $request->paymentID;
            $url = curl_init("$this->base_url/checkout/payment/execute/" . $paymentID);
            $header = array(
                'Content-Type:application/json',
                "authorization:$token",
                "x-app-key:$this->app_key"
            );

            curl_setopt($url, CURLOPT_HTTPHEADER, $header);
            curl_setopt($url, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($url, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($url, CURLOPT_FOLLOWLOCATION, 1);
            $resultdata = curl_exec($url);
            curl_close($url);

            $this->_processExecutePayment($resultdata);
            Log::error("successful executePayment from bkash");
            return json_decode($resultdata, true);
        }

        public function queryPayment(Request $request)
        {
            $token = session()->get('bkash_token');
            $paymentID = $request->payment_info['payment_id'];

            $url = curl_init("$this->base_url/checkout/payment/query/" . $paymentID);
            $header = array(
                'Content-Type:application/json',
                "authorization:$token",
                "x-app-key:$this->app_key"
            );

            curl_setopt($url, CURLOPT_HTTPHEADER, $header);
            curl_setopt($url, CURLOPT_CUSTOMREQUEST, "GET");
            curl_setopt($url, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($url, CURLOPT_FOLLOWLOCATION, 1);
            $resultdata = curl_exec($url);
            curl_close($url);
            return json_decode($resultdata, true);
        }

        public function bkashSuccess(Request $request)
        {


            // IF PAYMENT SUCCESS THEN YOU CAN APPLY YOUR CONDITION HERE
            if ($request->payment_info['transactionStatus'] == 'Completed') {

                Session::flash('successMsg', 'Payment has been Completed Successfully');

                return response()->json(['status' => true]);
            }

            Session::flash('error', 'Noman Error Message');

            return response()->json(['status' => false]);
        }

        public function _storeCreatePayment($data)
        {

            $data = json_decode($data);

            $username = Cookie::get('customer_username');
            $client = Client::where('userid',$username)->first();

            DB::table('bkash_payments')->insert([
                'paymentID' => $data->paymentID,
                'client_id' => $client->id,
                'amount' => $data->amount,
                'intent' => $data->intent,
                'merchantInvoiceNumber' => $data->merchantInvoiceNumber,
                'paymentCreateTime' => $data->createTime,
                'transactionStatus' => $data->transactionStatus
            ]);

        }

        public function _processExecutePayment($data)
        {
            $data = json_decode($data);

            try {
                if($data->transactionStatus == 'Completed'){

                    $username = Cookie::get('customer_username');
                    $client = Client::where('userid',$username)->first();

                    $payment = BkashPayment::updateOrInsert(
                        [
                            'paymentID' => $data->paymentID,
                            'client_id' => $client->id,
                            'amount' => $data->amount,
                        ],
                        [
                            'transactionStatus'         => $data->transactionStatus,
                            'paymentExecuteTime'        => $data->updateTime,
                            'trxID'                     => $data->trxID
                        ]
                    );

                    $status =   (new PaymentController)->bkashPaymentProcess($data->paymentID,'bkashPaymentFromClient');
                    Log::error("successful payment from bkash");

                }
            } catch (\Throwable $th) {
                Toastr::error('error','Try again');
                return redirect()->back();
            }




        }
}
