<?php

namespace App\Imports;

use App\Models\Client;
use App\Models\Clientsinfo;
use App\Models\MikcrotikClientList;
use App\Models\Packages;
use App\Models\Pop;
use App\Models\ReselleBalanceLogReport;
use App\Models\SubPackage;
use App\Models\SubResellerBalanceLogReport;
use Carbon\Carbon;
use DateTime;
use Exception;
use Facade\Ignition\Support\Packagist\Package;
use GuzzleHttp\Promise\Create;
use Maatwebsite\Excel\Concerns\Importable;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Throwable;

class ClientsImport implements ToCollection
{
    use Importable;
    public function collection(Collection $rows)
    {
        $count = 0;
        foreach ($rows as $row) {
            if ($count > 0) {
                try{
                    $client = Client::where('userid', $row[0])->first();

                    if($client){

                        $client->billing_cycle = $row[1];
                        if (is_numeric($row[2])) {
                            $client->expire_date = Carbon::parse(($row[2] - 25569) * 86400)->format('Y-m-d 00:00:00');
                        } else {
                            $client->expire_date = Carbon::parse($row[2])->format('Y-m-d 00:00:00');
                        }
                        $client->save();
                    }

                }catch(Exception $e){
                    dd($e, $count,$client);
                }

            }
            $count++;
        }
    }
}
